/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hudi.model.HudiTableType;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HudiTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String basePath;
    private final HudiTableType tableType;
    private final List<HiveColumnHandle> partitionColumns;
    private final Set<HiveColumnHandle> constraintColumns;
    private final TupleDomain<HiveColumnHandle> partitionPredicates;
    private final TupleDomain<HiveColumnHandle> regularPredicates;

    @JsonCreator
    public HudiTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="basePath") String basePath, @JsonProperty(value="tableType") HudiTableType tableType, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="partitionPredicates") TupleDomain<HiveColumnHandle> partitionPredicates, @JsonProperty(value="regularPredicates") TupleDomain<HiveColumnHandle> regularPredicates) {
        this(schemaName, tableName, basePath, tableType, partitionColumns, (Set<HiveColumnHandle>)ImmutableSet.of(), partitionPredicates, regularPredicates);
    }

    public HudiTableHandle(String schemaName, String tableName, String basePath, HudiTableType tableType, List<HiveColumnHandle> partitionColumns, Set<HiveColumnHandle> constraintColumns, TupleDomain<HiveColumnHandle> partitionPredicates, TupleDomain<HiveColumnHandle> regularPredicates) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.basePath = Objects.requireNonNull(basePath, "basePath is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.partitionColumns = Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.constraintColumns = Objects.requireNonNull(constraintColumns, "constraintColumns is null");
        this.partitionPredicates = Objects.requireNonNull(partitionPredicates, "partitionPredicates is null");
        this.regularPredicates = Objects.requireNonNull(regularPredicates, "regularPredicates is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getBasePath() {
        return this.basePath;
    }

    @JsonProperty
    public HudiTableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getPartitionPredicates() {
        return this.partitionPredicates;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public Set<HiveColumnHandle> getConstraintColumns() {
        return this.constraintColumns;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getRegularPredicates() {
        return this.regularPredicates;
    }

    public SchemaTableName getSchemaTableName() {
        return SchemaTableName.schemaTableName((String)this.schemaName, (String)this.tableName);
    }

    HudiTableHandle applyPredicates(Set<HiveColumnHandle> constraintColumns, TupleDomain<HiveColumnHandle> partitionTupleDomain, TupleDomain<HiveColumnHandle> regularTupleDomain) {
        return new HudiTableHandle(this.schemaName, this.tableName, this.basePath, this.tableType, this.partitionColumns, constraintColumns, (TupleDomain<HiveColumnHandle>)this.partitionPredicates.intersect(partitionTupleDomain), (TupleDomain<HiveColumnHandle>)this.regularPredicates.intersect(regularTupleDomain));
    }

    public String toString() {
        return this.getSchemaTableName().toString();
    }
}

