/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.trino.plugin.hudi.HudiMetadata;
import io.trino.plugin.hudi.HudiMetadataFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class HudiTransactionManager {
    private final Map<ConnectorTransactionHandle, MemoizedMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MemoizedMetadata>();
    private final HudiMetadataFactory metadataFactory;

    @Inject
    public HudiTransactionManager(HudiMetadataFactory metadataFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
    }

    public HudiMetadata get(ConnectorTransactionHandle transaction, ConnectorIdentity identity) {
        HudiMetadata metadata = this.transactions.get(transaction).get(identity);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        MemoizedMetadata metadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MemoizedMetadata transactionalMetadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((transactionalMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void put(ConnectorTransactionHandle transaction) {
        MemoizedMetadata existing = this.transactions.putIfAbsent(transaction, new MemoizedMetadata());
        Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"transaction already exists: %s", (Object)existing);
    }

    private class MemoizedMetadata {
        @GuardedBy(value="this")
        private HudiMetadata metadata;

        private MemoizedMetadata() {
        }

        public synchronized HudiMetadata get(ConnectorIdentity identity) {
            if (this.metadata == null) {
                try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
                    this.metadata = HudiTransactionManager.this.metadataFactory.create(identity);
                }
            }
            return this.metadata;
        }
    }
}

