/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.Table;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.table.HudiTableMetaClient;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimelineTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final List<Type> types;
    private final TrinoFileSystem fileSystem;
    private final String location;

    public TimelineTable(TrinoFileSystem fileSystem, SchemaTableName tableName, Table hudiTable) {
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("timestamp", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("action", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("state", (Type)VarcharType.VARCHAR)).build());
        this.types = (List)this.tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.location = Objects.requireNonNull(hudiTable.getStorage().getLocation(), "location is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        HudiTableMetaClient metaClient = HudiUtil.buildTableMetaClient(this.fileSystem, this.location);
        Iterable records = () -> metaClient.getCommitsTimeline().getInstants().map(this::getRecord).iterator();
        return new InMemoryRecordSet(this.types, records).cursor();
    }

    private List<Object> getRecord(HudiInstant hudiInstant) {
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(hudiInstant.getTimestamp());
        columns.add(hudiInstant.getAction());
        columns.add(hudiInstant.getState().toString());
        Preconditions.checkArgument((columns.size() == this.types.size() ? 1 : 0) != 0, (String)"Expected %s types in row, but got %s values", (int)this.types.size(), (int)columns.size());
        return columns;
    }
}

