/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.compaction;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.plugin.hudi.compaction.HudiCompactionOperation;
import io.trino.plugin.hudi.files.FSUtils;
import io.trino.plugin.hudi.files.HudiFileGroupId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CompactionOperation {
    private final String baseInstantTime;
    private final Optional<String> dataFileCommitTime;
    private final List<String> deltaFileNames;
    private final Optional<String> dataFileName;
    private final HudiFileGroupId id;
    private final Map<String, Double> metrics;
    private final Optional<String> bootstrapFilePath;

    public CompactionOperation(String baseInstantTime, Optional<String> dataFileCommitTime, List<String> deltaFileNames, Optional<String> dataFileName, HudiFileGroupId id, Map<String, Double> metrics, Optional<String> bootstrapFilePath) {
        this.baseInstantTime = Objects.requireNonNull(baseInstantTime, "baseInstantTime is null");
        this.dataFileCommitTime = Objects.requireNonNull(dataFileCommitTime, "dataFileCommitTime is null");
        this.deltaFileNames = Objects.requireNonNull(deltaFileNames, "deltaFileNames is null");
        this.dataFileName = Objects.requireNonNull(dataFileName, "dataFileName is null");
        this.id = Objects.requireNonNull(id, "id is null");
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
        this.bootstrapFilePath = Objects.requireNonNull(bootstrapFilePath, "bootstrapFilePath is null");
    }

    public String getPartitionPath() {
        return this.id.partitionPath();
    }

    public HudiFileGroupId getFileGroupId() {
        return this.id;
    }

    public static CompactionOperation convertFromAvroRecordInstance(HudiCompactionOperation operation) {
        Optional<String> dataFileName = Optional.ofNullable(operation.getDataFilePath());
        return new CompactionOperation(operation.getBaseInstantTime(), dataFileName.map(path -> FSUtils.getCommitTime(Location.of((String)path).fileName())), (List<String>)ImmutableList.copyOf(operation.getDeltaFilePaths()), dataFileName, new HudiFileGroupId(operation.getPartitionPath(), operation.getFileId()), (Map<String, Double>)(operation.getMetrics() == null ? ImmutableMap.of() : ImmutableMap.copyOf(operation.getMetrics())), Optional.ofNullable(operation.getBootstrapFilePath()));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseInstantTime", (Object)this.baseInstantTime).add("dataFileCommitTime", this.dataFileCommitTime).add("deltaFileNames", this.deltaFileNames).add("dataFileName", this.dataFileName).add("id", (Object)this.id).add("metrics", this.metrics).add("bootstrapFilePath", this.bootstrapFilePath).toString();
    }
}

