/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.compaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;

public class HudiCompactionOperation
extends SpecificRecordBase
implements SpecificRecord {
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieCompactionOperation\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"baseInstantTime\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"deltaFilePaths\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"dataFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"metrics\",\"type\":[\"null\",{\"type\":\"map\",\"values\":\"double\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"bootstrapFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}");
    private static final SpecificData MODEL = new SpecificData();
    private String baseInstantTime;
    private List<String> deltaFilePaths;
    private String dataFilePath;
    private String fileId;
    private String partitionPath;
    private Map<String, Double> metrics;
    private String bootstrapFilePath;

    public HudiCompactionOperation() {
    }

    public HudiCompactionOperation(String baseInstantTime, List<String> deltaFilePaths, String dataFilePath, String fileId, String partitionPath, Map<String, Double> metrics, String bootstrapFilePath) {
        this.baseInstantTime = Objects.requireNonNull(baseInstantTime, "baseInstantTime is null");
        this.deltaFilePaths = Objects.requireNonNull(deltaFilePaths, "deltaFilePaths is null");
        this.dataFilePath = Objects.requireNonNull(dataFilePath, "dataFilePath is null");
        this.fileId = Objects.requireNonNull(fileId, "fileId is null");
        this.partitionPath = Objects.requireNonNull(partitionPath, "partitionPath is null");
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
        this.bootstrapFilePath = Objects.requireNonNull(bootstrapFilePath, "bootstrapFilePath is null");
    }

    public SpecificData getSpecificData() {
        return MODEL;
    }

    public Schema getSchema() {
        return SCHEMA;
    }

    public Object get(int field) {
        return switch (field) {
            case 0 -> this.baseInstantTime;
            case 1 -> this.deltaFilePaths;
            case 2 -> this.dataFilePath;
            case 3 -> this.fileId;
            case 4 -> this.partitionPath;
            case 5 -> this.metrics;
            case 6 -> this.bootstrapFilePath;
            default -> throw new IndexOutOfBoundsException("Invalid index: " + field);
        };
    }

    public void put(int field, Object value) {
        switch (field) {
            case 0: {
                this.baseInstantTime = value != null ? value.toString() : null;
                break;
            }
            case 1: {
                this.deltaFilePaths = (List)value;
                break;
            }
            case 2: {
                this.dataFilePath = value != null ? value.toString() : null;
                break;
            }
            case 3: {
                this.fileId = value != null ? value.toString() : null;
                break;
            }
            case 4: {
                this.partitionPath = value != null ? value.toString() : null;
                break;
            }
            case 5: {
                this.metrics = (Map)value;
                break;
            }
            case 6: {
                this.bootstrapFilePath = value != null ? value.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field);
            }
        }
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public List<String> getDeltaFilePaths() {
        return this.deltaFilePaths;
    }

    public String getDataFilePath() {
        return this.dataFilePath;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public String getBootstrapFilePath() {
        return this.bootstrapFilePath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String baseInstantTime;
        private List<String> deltaFilePaths;
        private String dataFilePath;
        private String fileId;
        private String partitionPath;
        private Map<String, Double> metrics;
        private String bootstrapFilePath;

        private Builder() {
        }

        public Builder setBaseInstantTime(String baseInstantTime) {
            this.baseInstantTime = baseInstantTime;
            return this;
        }

        public Builder setDeltaFilePaths(List<String> deltaFilePaths) {
            this.deltaFilePaths = ImmutableList.copyOf(deltaFilePaths);
            return this;
        }

        public Builder setDataFilePath(String dataFilePath) {
            this.dataFilePath = dataFilePath;
            return this;
        }

        public Builder setFileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder setPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder setMetrics(Map<String, Double> metrics) {
            this.metrics = ImmutableMap.copyOf(metrics);
            return this;
        }

        public HudiCompactionOperation build() {
            return new HudiCompactionOperation(this.baseInstantTime, this.deltaFilePaths, this.dataFilePath, this.fileId, this.partitionPath, this.metrics, this.bootstrapFilePath);
        }
    }
}

