/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.files;

import com.google.common.base.MoreObjects;
import io.trino.plugin.hudi.files.HudiBaseFile;
import io.trino.plugin.hudi.files.HudiLogFile;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;

public class FileSlice {
    private final String baseInstantTime;
    private Optional<HudiBaseFile> baseFile;
    private final TreeSet<HudiLogFile> logFiles;

    public FileSlice(String baseInstantTime) {
        this.baseInstantTime = Objects.requireNonNull(baseInstantTime, "baseInstantTime is null");
        this.baseFile = Optional.empty();
        this.logFiles = new TreeSet<HudiLogFile>(HudiLogFile.getReverseLogFileComparator());
    }

    public void setBaseFile(HudiBaseFile baseFile) {
        this.baseFile = Optional.ofNullable(baseFile);
    }

    public void addLogFile(HudiLogFile logFile) {
        this.logFiles.add(logFile);
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public Optional<HudiBaseFile> getBaseFile() {
        return this.baseFile;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseInstantTime", (Object)this.baseInstantTime).add("baseFile", this.baseFile).add("logFiles", this.logFiles).toString();
    }
}

