/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.files;

import com.google.common.base.MoreObjects;
import io.trino.plugin.hudi.files.FileSlice;
import io.trino.plugin.hudi.files.HudiBaseFile;
import io.trino.plugin.hudi.files.HudiFileGroupId;
import io.trino.plugin.hudi.files.HudiLogFile;
import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.timeline.HudiTimeline;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;

public class HudiFileGroup {
    private final HudiFileGroupId fileGroupId;
    private final TreeMap<String, FileSlice> fileSlices;
    private final HudiTimeline timeline;
    private final Optional<HudiInstant> lastInstant;

    public static Comparator<String> getReverseCommitTimeComparator() {
        return Comparator.reverseOrder();
    }

    public HudiFileGroup(String partitionPath, String id, HudiTimeline timeline) {
        this(new HudiFileGroupId(partitionPath, id), timeline);
    }

    public HudiFileGroup(HudiFileGroupId fileGroupId, HudiTimeline timeline) {
        this.fileGroupId = Objects.requireNonNull(fileGroupId, "fileGroupId is null");
        this.fileSlices = new TreeMap(HudiFileGroup.getReverseCommitTimeComparator());
        this.lastInstant = timeline.lastInstant();
        this.timeline = timeline;
    }

    public void addNewFileSliceAtInstant(String baseInstantTime) {
        if (!this.fileSlices.containsKey(baseInstantTime)) {
            this.fileSlices.put(baseInstantTime, new FileSlice(baseInstantTime));
        }
    }

    public void addBaseFile(HudiBaseFile dataFile) {
        if (!this.fileSlices.containsKey(dataFile.getCommitTime())) {
            this.fileSlices.put(dataFile.getCommitTime(), new FileSlice(dataFile.getCommitTime()));
        }
        this.fileSlices.get(dataFile.getCommitTime()).setBaseFile(dataFile);
    }

    public void addLogFile(HudiLogFile logFile) {
        if (!this.fileSlices.containsKey(logFile.getBaseCommitTime())) {
            this.fileSlices.put(logFile.getBaseCommitTime(), new FileSlice(logFile.getBaseCommitTime()));
        }
        this.fileSlices.get(logFile.getBaseCommitTime()).addLogFile(logFile);
    }

    public String getPartitionPath() {
        return this.fileGroupId.partitionPath();
    }

    public HudiFileGroupId getFileGroupId() {
        return this.fileGroupId;
    }

    private boolean isFileSliceCommitted(FileSlice slice) {
        if (!HudiTimeline.compareTimestamps(slice.getBaseInstantTime(), HudiTimeline.LESSER_THAN_OR_EQUALS, this.lastInstant.get().getTimestamp())) {
            return false;
        }
        return this.timeline.containsOrBeforeTimelineStarts(slice.getBaseInstantTime());
    }

    public Stream<FileSlice> getAllFileSlices() {
        if (!this.timeline.empty()) {
            return this.fileSlices.values().stream().filter(this::isFileSliceCommitted);
        }
        return Stream.empty();
    }

    public Stream<HudiBaseFile> getAllBaseFiles() {
        return this.getAllFileSlices().filter(slice -> slice.getBaseFile().isPresent()).map(slice -> slice.getBaseFile().get());
    }

    public Stream<FileSlice> getAllFileSlicesBeforeOn(String maxInstantTime) {
        return this.fileSlices.values().stream().filter(slice -> HudiTimeline.compareTimestamps(slice.getBaseInstantTime(), HudiTimeline.LESSER_THAN_OR_EQUALS, maxInstantTime));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileGroupId", (Object)this.fileGroupId).add("fileSlices", this.fileSlices).add("timeline", (Object)this.timeline).add("lastInstant", this.lastInstant).toString();
    }

    public HudiTimeline getTimeline() {
        return this.timeline;
    }
}

