/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HudiReplaceCommitMetadata {
    private final Map<String, List<String>> partitionToReplaceFileIds;
    private final boolean compacted;

    @JsonCreator
    public HudiReplaceCommitMetadata(@JsonProperty(value="partitionToReplaceFileIds") Map<String, List<String>> partitionToReplaceFileIds, @JsonProperty(value="compacted") boolean compacted) {
        this.partitionToReplaceFileIds = ImmutableMap.copyOf(Objects.requireNonNull(partitionToReplaceFileIds, "partitionToReplaceFileIds is null"));
        this.compacted = compacted;
    }

    public Map<String, List<String>> getPartitionToReplaceFileIds() {
        return this.partitionToReplaceFileIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiReplaceCommitMetadata that = (HudiReplaceCommitMetadata)o;
        return this.partitionToReplaceFileIds.equals(that.partitionToReplaceFileIds) && this.compacted == that.compacted;
    }

    public int hashCode() {
        return Objects.hash(this.partitionToReplaceFileIds, this.compacted);
    }

    public static <T> T fromBytes(byte[] bytes, ObjectMapper objectMapper, Class<T> clazz) throws IOException {
        try {
            String jsonStr = new String(bytes, StandardCharsets.UTF_8);
            if (jsonStr == null || jsonStr.isEmpty()) {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)objectMapper.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata", e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionToReplaceFileIds", this.partitionToReplaceFileIds).add("compacted", this.compacted).toString();
    }
}

