/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.timeline;

import io.trino.plugin.hudi.model.HudiInstant;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public interface HudiTimeline {
    public static final String COMMIT_ACTION = "commit";
    public static final String DELTA_COMMIT_ACTION = "deltacommit";
    public static final String CLEAN_ACTION = "clean";
    public static final String ROLLBACK_ACTION = "rollback";
    public static final String SAVEPOINT_ACTION = "savepoint";
    public static final String REPLACE_COMMIT_ACTION = "replacecommit";
    public static final String INFLIGHT_EXTENSION = ".inflight";
    public static final String COMPACTION_ACTION = "compaction";
    public static final String REQUESTED_EXTENSION = ".requested";
    public static final String RESTORE_ACTION = "restore";
    public static final String INDEXING_ACTION = "indexing";
    public static final String SCHEMA_COMMIT_ACTION = "schemacommit";
    public static final String COMMIT_EXTENSION = ".commit";
    public static final String DELTA_COMMIT_EXTENSION = ".deltacommit";
    public static final String CLEAN_EXTENSION = ".clean";
    public static final String ROLLBACK_EXTENSION = ".rollback";
    public static final String SAVEPOINT_EXTENSION = ".savepoint";
    public static final String INFLIGHT_COMMIT_EXTENSION = ".inflight";
    public static final String REQUESTED_COMMIT_EXTENSION = ".commit.requested";
    public static final String REQUESTED_DELTA_COMMIT_EXTENSION = ".deltacommit.requested";
    public static final String INFLIGHT_DELTA_COMMIT_EXTENSION = ".deltacommit.inflight";
    public static final String INFLIGHT_CLEAN_EXTENSION = ".clean.inflight";
    public static final String REQUESTED_CLEAN_EXTENSION = ".clean.requested";
    public static final String INFLIGHT_ROLLBACK_EXTENSION = ".rollback.inflight";
    public static final String REQUESTED_ROLLBACK_EXTENSION = ".rollback.requested";
    public static final String INFLIGHT_SAVEPOINT_EXTENSION = ".savepoint.inflight";
    public static final String REQUESTED_COMPACTION_SUFFIX = String.join((CharSequence)"", "compaction", ".requested");
    public static final String REQUESTED_COMPACTION_EXTENSION = String.join((CharSequence)".", REQUESTED_COMPACTION_SUFFIX);
    public static final String INFLIGHT_COMPACTION_EXTENSION = String.join((CharSequence)".", "compaction", ".inflight");
    public static final String REQUESTED_RESTORE_EXTENSION = ".restore.requested";
    public static final String INFLIGHT_RESTORE_EXTENSION = ".restore.inflight";
    public static final String RESTORE_EXTENSION = ".restore";
    public static final String INFLIGHT_REPLACE_COMMIT_EXTENSION = ".replacecommit.inflight";
    public static final String REQUESTED_REPLACE_COMMIT_EXTENSION = ".replacecommit.requested";
    public static final String REPLACE_COMMIT_EXTENSION = ".replacecommit";
    public static final String INFLIGHT_INDEX_COMMIT_EXTENSION = ".indexing.inflight";
    public static final String REQUESTED_INDEX_COMMIT_EXTENSION = ".indexing.requested";
    public static final String INDEX_COMMIT_EXTENSION = ".indexing";
    public static final String SAVE_SCHEMA_ACTION_EXTENSION = ".schemacommit";
    public static final String INFLIGHT_SAVE_SCHEMA_ACTION_EXTENSION = ".schemacommit.inflight";
    public static final String REQUESTED_SAVE_SCHEMA_ACTION_EXTENSION = ".schemacommit.requested";
    public static final BiPredicate<String, String> LESSER_THAN_OR_EQUALS = (commit1, commit2) -> commit1.compareTo((String)commit2) <= 0;
    public static final BiPredicate<String, String> LESSER_THAN = (commit1, commit2) -> commit1.compareTo((String)commit2) < 0;

    public HudiTimeline filterCompletedInstants();

    public HudiTimeline getWriteTimeline();

    public HudiTimeline getCompletedReplaceTimeline();

    public HudiTimeline filterPendingCompactionTimeline();

    public HudiTimeline filterPendingReplaceTimeline();

    public boolean empty();

    public int countInstants();

    public Optional<HudiInstant> firstInstant();

    public Optional<HudiInstant> nthInstant(int var1);

    public Optional<HudiInstant> lastInstant();

    public boolean containsOrBeforeTimelineStarts(String var1);

    public Stream<HudiInstant> getInstants();

    public boolean isBeforeTimelineStarts(String var1);

    public Optional<HudiInstant> getFirstNonSavepointCommit();

    public Optional<byte[]> getInstantDetails(HudiInstant var1);

    public static boolean compareTimestamps(String commit1, BiPredicate<String, String> predicateToApply, String commit2) {
        return predicateToApply.test(commit1, commit2);
    }

    public static HudiInstant getCompactionRequestedInstant(String timestamp) {
        return new HudiInstant(HudiInstant.State.REQUESTED, COMPACTION_ACTION, timestamp);
    }

    public static String makeCommitFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, COMMIT_EXTENSION);
    }

    public static String makeInflightCommitFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, ".inflight");
    }

    public static String makeRequestedCommitFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, REQUESTED_COMMIT_EXTENSION);
    }

    public static String makeCleanerFileName(String instant) {
        return String.join((CharSequence)"", instant, CLEAN_EXTENSION);
    }

    public static String makeRequestedCleanerFileName(String instant) {
        return String.join((CharSequence)"", instant, REQUESTED_CLEAN_EXTENSION);
    }

    public static String makeInflightCleanerFileName(String instant) {
        return String.join((CharSequence)"", instant, INFLIGHT_CLEAN_EXTENSION);
    }

    public static String makeRollbackFileName(String instant) {
        return String.join((CharSequence)"", instant, ROLLBACK_EXTENSION);
    }

    public static String makeRequestedRollbackFileName(String instant) {
        return String.join((CharSequence)"", instant, REQUESTED_ROLLBACK_EXTENSION);
    }

    public static String makeRequestedRestoreFileName(String instant) {
        return String.join((CharSequence)"", instant, REQUESTED_RESTORE_EXTENSION);
    }

    public static String makeInflightRollbackFileName(String instant) {
        return String.join((CharSequence)"", instant, INFLIGHT_ROLLBACK_EXTENSION);
    }

    public static String makeInflightSavePointFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, INFLIGHT_SAVEPOINT_EXTENSION);
    }

    public static String makeSavePointFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, SAVEPOINT_EXTENSION);
    }

    public static String makeInflightDeltaFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, INFLIGHT_DELTA_COMMIT_EXTENSION);
    }

    public static String makeRequestedDeltaFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, REQUESTED_DELTA_COMMIT_EXTENSION);
    }

    public static String makeInflightCompactionFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, INFLIGHT_COMPACTION_EXTENSION);
    }

    public static String makeRequestedCompactionFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, REQUESTED_COMPACTION_EXTENSION);
    }

    public static String makeRestoreFileName(String instant) {
        return String.join((CharSequence)"", instant, RESTORE_EXTENSION);
    }

    public static String makeInflightRestoreFileName(String instant) {
        return String.join((CharSequence)"", instant, INFLIGHT_RESTORE_EXTENSION);
    }

    public static String makeReplaceFileName(String instant) {
        return String.join((CharSequence)"", instant, REPLACE_COMMIT_EXTENSION);
    }

    public static String makeInflightReplaceFileName(String instant) {
        return String.join((CharSequence)"", instant, INFLIGHT_REPLACE_COMMIT_EXTENSION);
    }

    public static String makeRequestedReplaceFileName(String instant) {
        return String.join((CharSequence)"", instant, REQUESTED_REPLACE_COMMIT_EXTENSION);
    }

    public static String makeDeltaFileName(String instantTime) {
        return instantTime + DELTA_COMMIT_EXTENSION;
    }

    public static String makeIndexCommitFileName(String instant) {
        return String.join((CharSequence)"", instant, INDEX_COMMIT_EXTENSION);
    }

    public static String makeInflightIndexFileName(String instant) {
        return String.join((CharSequence)"", instant, INFLIGHT_INDEX_COMMIT_EXTENSION);
    }

    public static String makeRequestedIndexFileName(String instant) {
        return String.join((CharSequence)"", instant, REQUESTED_INDEX_COMMIT_EXTENSION);
    }

    public static String makeSchemaFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, SAVE_SCHEMA_ACTION_EXTENSION);
    }

    public static String makeInflightSchemaFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, INFLIGHT_SAVE_SCHEMA_ACTION_EXTENSION);
    }

    public static String makeRequestSchemaFileName(String instantTime) {
        return String.join((CharSequence)"", instantTime, REQUESTED_SAVE_SCHEMA_ACTION_EXTENSION);
    }
}

