/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.timeline;

import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.timeline.TimelineLayoutVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class TimelineLayout {
    private static final Map<TimelineLayoutVersion, TimelineLayout> LAYOUT_MAP = new HashMap<TimelineLayoutVersion, TimelineLayout>();

    public static TimelineLayout getLayout(TimelineLayoutVersion version) {
        return LAYOUT_MAP.get(version);
    }

    public abstract Stream<HudiInstant> filterHoodieInstants(Stream<HudiInstant> var1);

    static {
        LAYOUT_MAP.put(new TimelineLayoutVersion(TimelineLayoutVersion.VERSION_0), new TimelineLayoutV0());
        LAYOUT_MAP.put(new TimelineLayoutVersion(TimelineLayoutVersion.VERSION_1), new TimelineLayoutV1());
    }

    private static class TimelineLayoutV0
    extends TimelineLayout {
        private TimelineLayoutV0() {
        }

        @Override
        public Stream<HudiInstant> filterHoodieInstants(Stream<HudiInstant> instantStream) {
            return instantStream;
        }
    }

    private static class TimelineLayoutV1
    extends TimelineLayout {
        private TimelineLayoutV1() {
        }

        @Override
        public Stream<HudiInstant> filterHoodieInstants(Stream<HudiInstant> instantStream) {
            return instantStream.collect(Collectors.groupingBy(instant -> Map.entry(instant.getTimestamp(), HudiInstant.getComparableAction(instant.getAction())))).values().stream().map(hoodieInstants -> (HudiInstant)hoodieInstants.stream().reduce((x, y) -> {
                if (x.getState().compareTo(y.getState()) >= 0) {
                    return x;
                }
                return y;
            }).get());
        }
    }
}

