/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.timeline;

import com.google.common.base.Preconditions;

public record TimelineLayoutVersion(Integer version) implements Comparable<TimelineLayoutVersion>
{
    public static final Integer VERSION_0 = 0;
    public static final Integer VERSION_1;
    private static final Integer CURRENT_VERSION;
    public static final TimelineLayoutVersion CURRENT_LAYOUT_VERSION;

    public TimelineLayoutVersion {
        Preconditions.checkArgument((version <= CURRENT_VERSION ? 1 : 0) != 0);
        Preconditions.checkArgument((version >= VERSION_0 ? 1 : 0) != 0);
    }

    @Override
    public int compareTo(TimelineLayoutVersion o) {
        return Integer.compare(this.version, o.version);
    }

    @Override
    public String toString() {
        return String.valueOf(this.version);
    }

    static {
        CURRENT_VERSION = VERSION_1 = Integer.valueOf(1);
        CURRENT_LAYOUT_VERSION = new TimelineLayoutVersion(CURRENT_VERSION);
    }
}

