/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.JdbcAssignmentItem;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcMergeSink;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcRelationHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.JoinType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class PhoenixMergeSink
implements ConnectorMergeSink {
    private final ConnectorMergeSink delegate;

    public PhoenixMergeSink(ConnectorSession session, ConnectorMergeTableHandle mergeHandle, PhoenixClient phoenixClient, ConnectorPageSinkId pageSinkId, RemoteQueryModifier queryModifier, QueryBuilder queryBuilder) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(mergeHandle, "mergeHandle is null");
        Objects.requireNonNull(phoenixClient, "phoenixClient is null");
        Objects.requireNonNull(pageSinkId, "pageSinkId is null");
        Objects.requireNonNull(queryModifier, "queryModifier is null");
        Objects.requireNonNull(queryBuilder, "queryBuilder is null");
        this.delegate = new JdbcMergeSink(session, mergeHandle, (JdbcClient)phoenixClient, pageSinkId, queryModifier, (QueryBuilder)new MergeQueryBuilder(queryBuilder));
    }

    public void storeMergedRows(Page page) {
        this.delegate.storeMergedRows(page);
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return this.delegate.finish();
    }

    public void abort() {
        this.delegate.abort();
    }

    private record MergeQueryBuilder(QueryBuilder delegate) implements QueryBuilder
    {
        public PreparedQuery prepareSelectQuery(JdbcClient client, ConnectorSession session, Connection connection, JdbcRelationHandle baseRelation, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, ParameterizedExpression> columnExpressions, TupleDomain<ColumnHandle> tupleDomain, Optional<ParameterizedExpression> additionalPredicate) {
            throw new UnsupportedOperationException("Not supported");
        }

        public PreparedQuery prepareJoinQuery(JdbcClient client, ConnectorSession session, Connection connection, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions) {
            throw new UnsupportedOperationException("Not supported");
        }

        public PreparedQuery legacyPrepareJoinQuery(JdbcClient client, ConnectorSession session, Connection connection, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> leftAssignments, Map<JdbcColumnHandle, String> rightAssignments) {
            throw new UnsupportedOperationException("Not supported");
        }

        public PreparedQuery prepareDeleteQuery(JdbcClient client, ConnectorSession session, Connection connection, JdbcNamedRelationHandle baseRelation, TupleDomain<ColumnHandle> tupleDomain, Optional<ParameterizedExpression> additionalPredicate) {
            return this.delegate.prepareDeleteQuery(client, session, connection, baseRelation, tupleDomain, additionalPredicate);
        }

        public PreparedQuery prepareUpdateQuery(JdbcClient client, ConnectorSession session, Connection connection, JdbcNamedRelationHandle baseRelation, TupleDomain<ColumnHandle> tupleDomain, Optional<ParameterizedExpression> additionalPredicate, List<JdbcAssignmentItem> assignments) {
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            ImmutableList.Builder writeFunctionBuilder = ImmutableList.builder();
            for (JdbcAssignmentItem jdbcAssignmentItem : assignments) {
                JdbcColumnHandle column = jdbcAssignmentItem.column();
                namesBuilder.add((Object)column.getColumnName());
                typesBuilder.add((Object)column.getColumnType());
                writeFunctionBuilder.add((Object)MergeQueryBuilder.getWriteFunction(client, session, column.getColumnType()));
            }
            Map domains = (Map)tupleDomain.getDomains().orElseThrow(() -> new IllegalArgumentException("primary keys domain not exists"));
            for (ColumnHandle columnHandle : domains.keySet()) {
                JdbcColumnHandle column = (JdbcColumnHandle)columnHandle;
                namesBuilder.add((Object)column.getColumnName());
                typesBuilder.add((Object)column.getColumnType());
                writeFunctionBuilder.add((Object)MergeQueryBuilder.getWriteFunction(client, session, column.getColumnType()));
            }
            String string = client.buildInsertSql((JdbcOutputTableHandle)new PhoenixOutputTableHandle(baseRelation.getRemoteTableName(), (List<String>)namesBuilder.build(), (List<Type>)typesBuilder.build(), Optional.empty(), Optional.empty()), (List)writeFunctionBuilder.build());
            return new PreparedQuery(string, (List)ImmutableList.of());
        }

        public PreparedStatement prepareStatement(JdbcClient client, ConnectorSession session, Connection connection, PreparedQuery preparedQuery, Optional<Integer> columnCount) {
            throw new UnsupportedOperationException("Not supported");
        }

        public CallableStatement callProcedure(JdbcClient client, ConnectorSession session, Connection connection, JdbcProcedureHandle.ProcedureQuery procedureQuery) {
            throw new UnsupportedOperationException("Not supported");
        }

        private static WriteFunction getWriteFunction(JdbcClient client, ConnectorSession session, Type type) {
            return client.toWriteMapping(session, type).getWriteFunction();
        }
    }
}

