/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMergeTableHandle;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import io.trino.plugin.phoenix5.MetadataUtil;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixErrorCode;
import io.trino.plugin.phoenix5.PhoenixMergeTableHandle;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.expression.Constant;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMetadata
extends DefaultJdbcMetadata {
    public static final String DEFAULT_SCHEMA = "default";
    private static final String ROWKEY = "ROWKEY";
    private final PhoenixClient phoenixClient;
    private final IdentifierMapping identifierMapping;

    @Inject
    public PhoenixMetadata(PhoenixClient phoenixClient, TimestampTimeZoneDomain timestampTimeZoneDomain, IdentifierMapping identifierMapping, Set<JdbcQueryEventListener> jdbcQueryEventListeners) {
        super((JdbcClient)phoenixClient, timestampTimeZoneDomain, false, jdbcQueryEventListeners);
        this.phoenixClient = Objects.requireNonNull(phoenixClient, "phoenixClient is null");
        this.identifierMapping = Objects.requireNonNull(identifierMapping, "identifierMapping is null");
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        return this.phoenixClient.getTableHandle(session, schemaTableName).map(JdbcTableHandle::asPlainTable).map(JdbcNamedRelationHandle::getRemoteTableName).map(remoteTableName -> new JdbcTableHandle(schemaTableName, new RemoteTableName(remoteTableName.getCatalogName(), Optional.ofNullable(MetadataUtil.toTrinoSchemaName(remoteTableName.getSchemaName().orElse(null))), remoteTableName.getTableName()), Optional.empty())).orElse(null);
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        List sortingProperties = (List)tableHandle.getSortOrder().map(properties -> (ImmutableList)properties.stream().map(item -> new SortingProperty((Object)item.column(), item.sortOrder())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        return new ConnectorTableProperties(TupleDomain.all(), Optional.empty(), Optional.empty(), sortingProperties);
    }

    public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableSchema(handle.getRequiredNamedRelation().getSchemaTableName(), (List)this.getColumnMetadata(session, handle).stream().map(ColumnMetadata::getColumnSchema).collect(ImmutableList.toImmutableList()));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableMetadata(handle.getRequiredNamedRelation().getSchemaTableName(), this.getColumnMetadata(session, handle), this.phoenixClient.getTableProperties(session, handle));
    }

    public List<ColumnMetadata> getColumnMetadata(ConnectorSession session, JdbcTableHandle handle) {
        return (List)JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this.phoenixClient, (JdbcTableHandle)handle).stream().filter(column -> !ROWKEY.equalsIgnoreCase(column.getColumnName())).map(JdbcColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        if (DEFAULT_SCHEMA.equalsIgnoreCase(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't create 'default' schema which maps to Phoenix empty schema");
        }
        this.phoenixClient.execute(session, String.format("CREATE SCHEMA %s", SchemaUtil.getEscapedArgument((String)this.toRemoteSchemaName(session, schemaName))));
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        if (cascade) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas with CASCADE option");
        }
        if (DEFAULT_SCHEMA.equalsIgnoreCase(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't drop 'default' schema which maps to Phoenix empty schema");
        }
        this.phoenixClient.execute(session, String.format("DROP SCHEMA %s", SchemaUtil.getEscapedArgument((String)this.toRemoteSchemaName(session, schemaName))));
    }

    private String toRemoteSchemaName(ConnectorSession session, String schemaName) {
        String string;
        block8: {
            Connection connection = this.phoenixClient.getConnection(session);
            try {
                string = this.identifierMapping.toRemoteSchemaName(this.phoenixClient.getRemoteIdentifiers(connection), session.getIdentity(), schemaName);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Couldn't get casing for the schema name", (Throwable)e);
                }
            }
            connection.close();
        }
        return string;
    }

    public Optional<ConnectorTableHandle> applyUpdate(ConnectorSession session, ConnectorTableHandle handle, Map<ColumnHandle, Constant> assignments) {
        return Optional.empty();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        this.phoenixClient.beginCreateTable(session, tableMetadata);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        if (replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        return this.phoenixClient.beginCreateTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        Optional<String> rowkeyColumn = JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this.phoenixClient, (JdbcTableHandle)handle).stream().map(JdbcColumnHandle::getColumnName).filter(ROWKEY::equalsIgnoreCase).findFirst();
        List columnHandles = (List)columns.stream().map(JdbcColumnHandle.class::cast).filter(column -> !ROWKEY.equalsIgnoreCase(column.getColumnName())).collect(ImmutableList.toImmutableList());
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        return new PhoenixOutputTableHandle(remoteTableName, (List)columnHandles.stream().map(JdbcColumnHandle::getColumnName).collect(ImmutableList.toImmutableList()), (List)columnHandles.stream().map(JdbcColumnHandle::getColumnType).collect(ImmutableList.toImmutableList()), Optional.of((List)columnHandles.stream().map(JdbcColumnHandle::getJdbcTypeHandle).collect(ImmutableList.toImmutableList())), rowkeyColumn);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column, ColumnPosition position) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with comments");
        }
        ColumnPosition columnPosition = position;
        Objects.requireNonNull(columnPosition);
        ColumnPosition columnPosition2 = columnPosition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with FIRST clause");
            }
            case 1: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with AFTER clause");
            }
            case 2: 
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        this.phoenixClient.execute(session, String.format("ALTER TABLE %s ADD %s %s", MetadataUtil.getEscapedTableName(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.phoenixClient.quoted(column.getName()), this.phoenixClient.toWriteMapping(session, column.getType()).getDataType()));
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        this.phoenixClient.execute(session, String.format("ALTER TABLE %s DROP COLUMN %s", MetadataUtil.getEscapedTableName(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.phoenixClient.quoted(columnHandle.getColumnName())));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        boolean hasRowkey = this.getColumnHandles(session, tableHandle).values().stream().map(JdbcColumnHandle.class::cast).map(JdbcColumnHandle::getColumnName).anyMatch(ROWKEY::equals);
        if (hasRowkey) {
            JdbcTableHandle jdbcHandle = (JdbcTableHandle)tableHandle;
            RemoteTableName remoteTableName = jdbcHandle.asPlainTable().getRemoteTableName();
            this.phoenixClient.execute(session, String.format("DROP SEQUENCE %s", MetadataUtil.getEscapedTableName(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName() + "_sequence")));
        }
        this.phoenixClient.dropTable(session, (JdbcTableHandle)tableHandle);
    }

    public JdbcColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        List fields = (List)this.phoenixClient.getPrimaryKeys(session, handle.getRequiredNamedRelation().getRemoteTableName()).stream().map(columnHandle -> new RowType.Field(Optional.of(columnHandle.getColumnName()), columnHandle.getColumnType())).collect(ImmutableList.toImmutableList());
        Verify.verify((!fields.isEmpty() ? 1 : 0) != 0, (String)"Phoenix primary key is empty", (Object[])new Object[0]);
        return new JdbcColumnHandle("$merge_row_id", new JdbcTypeHandle(-8, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), (Type)RowType.from((List)fields));
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateColumnHandles, RetryMode retryMode) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        JdbcMergeTableHandle mergeTableHandle = (JdbcMergeTableHandle)super.beginMerge(session, tableHandle, updateColumnHandles, retryMode);
        List primaryKeys = mergeTableHandle.getPrimaryKeys();
        List columns = (List)this.phoenixClient.getColumns(session, handle.getRequiredNamedRelation().getSchemaTableName(), handle.getRequiredNamedRelation().getRemoteTableName()).stream().filter(column -> !ROWKEY.equalsIgnoreCase(column.getColumnName())).collect(ImmutableList.toImmutableList());
        for (Collection<ColumnHandle> updateColumns : updateColumnHandles.values()) {
            for (ColumnHandle column2 : updateColumns) {
                Preconditions.checkArgument((boolean)columns.contains(column2), (Object)"the update column not found in the target table");
                Preconditions.checkArgument((!primaryKeys.contains(column2) ? 1 : 0) != 0, (Object)"Phoenix does not allow update primary key");
            }
        }
        if (handle.getColumns().isPresent()) {
            handle = new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), handle.getConstraintExpressions(), handle.getSortOrder(), handle.getLimit(), Optional.of(columns), handle.getOtherReferencedTables(), handle.getNextSyntheticColumnId(), handle.getAuthorization(), handle.getUpdateAssignments());
        }
        return new PhoenixMergeTableHandle(handle, (PhoenixOutputTableHandle)mergeTableHandle.getOutputTableHandle(), primaryKeys, columns, mergeTableHandle.getUpdateCaseColumns());
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support truncating tables");
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return Optional.empty();
    }
}

