/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.inject.Inject;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcPageSinkProvider;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixMergeSink;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class PhoenixPageSinkProvider
implements ConnectorPageSinkProvider {
    private final JdbcPageSinkProvider delegate;
    private final PhoenixClient jdbcClient;
    private final RemoteQueryModifier remoteQueryModifier;
    private final QueryBuilder queryBuilder;

    @Inject
    public PhoenixPageSinkProvider(PhoenixClient jdbcClient, RemoteQueryModifier remoteQueryModifier, QueryBuilder queryBuilder) {
        this.delegate = new JdbcPageSinkProvider((JdbcClient)jdbcClient, remoteQueryModifier, queryBuilder);
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.remoteQueryModifier = Objects.requireNonNull(remoteQueryModifier, "remoteQueryModifier is null");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        return this.delegate.createPageSink(transactionHandle, session, outputTableHandle, pageSinkId);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        return this.delegate.createPageSink(transactionHandle, session, insertTableHandle, pageSinkId);
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        return new PhoenixMergeSink(session, mergeHandle, this.jdbcClient, pageSinkId, this.remoteQueryModifier, this.queryBuilder);
    }
}

