/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.tpcds.TpcdsMetadata;
import io.trino.plugin.tpcds.TpcdsNodePartitioningProvider;
import io.trino.plugin.tpcds.TpcdsRecordSetProvider;
import io.trino.plugin.tpcds.TpcdsSessionProperties;
import io.trino.plugin.tpcds.TpcdsSplitManager;
import io.trino.plugin.tpcds.TpcdsTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;

public class TpcdsConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final TpcdsMetadata metadata;
    private final TpcdsSplitManager splitManager;
    private final TpcdsRecordSetProvider recordSetProvider;
    private final TpcdsNodePartitioningProvider nodePartitioningProvider;
    private final TpcdsSessionProperties sessionProperties;

    @Inject
    public TpcdsConnector(LifeCycleManager lifeCycleManager, TpcdsMetadata metadata, TpcdsSplitManager splitManager, TpcdsRecordSetProvider recordSetProvider, TpcdsNodePartitioningProvider nodePartitioningProvider, TpcdsSessionProperties sessionProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return TpcdsTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties.getSessionProperties();
    }

    public void shutdown() {
        this.lifeCycleManager.stop();
    }
}

