/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ObsoleteApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.util.TimeConversionUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Set;

@InternalExtensionOnly
public class UnaryCallSettings<RequestT, ResponseT> {
    private final ImmutableSet<StatusCode.Code> retryableCodes;
    private final RetrySettings retrySettings;

    public final Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    public final RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newUnaryCallSettingsBuilder() {
        return new Builder();
    }

    public Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    protected UnaryCallSettings(Builder<RequestT, ResponseT> builder) {
        this.retryableCodes = ImmutableSet.copyOf(((Builder)builder).retryableCodes);
        this.retrySettings = ((Builder)builder).retrySettingsBuilder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("retryableCodes", this.retryableCodes).add("retrySettings", this.retrySettings).toString();
    }

    public int hashCode() {
        int prime = 43;
        int result = prime + (this.retrySettings == null ? 0 : this.retrySettings.hashCode());
        result = prime * result + (this.retryableCodes == null ? 0 : this.retryableCodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryCallSettings other = (UnaryCallSettings)obj;
        if (!this.retrySettings.equals(other.retrySettings)) {
            return false;
        }
        return this.retryableCodes.equals(other.retryableCodes);
    }

    public static class Builder<RequestT, ResponseT> {
        private Set<StatusCode.Code> retryableCodes;
        private RetrySettings.Builder retrySettingsBuilder;

        protected Builder() {
            this.retryableCodes = Sets.newHashSet();
            this.retrySettingsBuilder = RetrySettings.newBuilder();
        }

        protected Builder(UnaryCallSettings<RequestT, ResponseT> unaryCallSettings) {
            this.setRetryableCodes(((UnaryCallSettings)unaryCallSettings).retryableCodes);
            this.setRetrySettings(unaryCallSettings.getRetrySettings());
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            this.retryableCodes = Sets.newHashSet(retryableCodes);
            return this;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(StatusCode.Code ... codes) {
            this.setRetryableCodes(Sets.newHashSet(codes));
            return this;
        }

        public RetrySettings.Builder retrySettings() {
            return this.retrySettingsBuilder;
        }

        public Builder<RequestT, ResponseT> setRetrySettings(RetrySettings retrySettings) {
            this.retrySettingsBuilder = retrySettings.toBuilder();
            return this;
        }

        @ObsoleteApi(value="Use setSimpleTimeoutNoRetriesDuration(java.time.Duration) instead")
        public Builder<RequestT, ResponseT> setSimpleTimeoutNoRetries(com.google.cloud.hadoop.repackaged.gcs.org.threeten.bp.Duration timeout) {
            return this.setSimpleTimeoutNoRetriesDuration(TimeConversionUtils.toJavaTimeDuration(timeout));
        }

        public Builder<RequestT, ResponseT> setSimpleTimeoutNoRetriesDuration(Duration timeout) {
            this.setRetryableCodes(new StatusCode.Code[0]);
            this.setRetrySettings(RetrySettings.newBuilder().setTotalTimeoutDuration(timeout).setInitialRetryDelayDuration(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelayDuration(Duration.ZERO).setInitialRpcTimeoutDuration(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(timeout).setMaxAttempts(1).build());
            return this;
        }

        public Set<StatusCode.Code> getRetryableCodes() {
            return this.retryableCodes;
        }

        public RetrySettings getRetrySettings() {
            return this.retrySettingsBuilder.build();
        }

        public UnaryCallSettings<RequestT, ResponseT> build() {
            return new UnaryCallSettings(this);
        }
    }
}

