/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.GenericUrl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponseException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpClientContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpContentRange;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.JsonResumableSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableSessionFailureScenario;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.RewindableContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.Status;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSessionPutTask
implements Callable<ResumableOperationResult<StorageObject>> {
    private final HttpClientContext context;
    private final String uploadId;
    private final RewindableContent content;
    private final HttpContentRange originalContentRange;
    private HttpContentRange contentRange;

    @VisibleForTesting
    JsonResumableSessionPutTask(HttpClientContext httpClientContext, String uploadId, RewindableContent content, HttpContentRange originalContentRange) {
        this.context = httpClientContext;
        this.uploadId = uploadId;
        this.content = content;
        this.originalContentRange = originalContentRange;
        this.contentRange = originalContentRange;
    }

    public void rewindTo(long offset) {
        if (this.originalContentRange instanceof HttpContentRange.HasRange) {
            HttpContentRange.HasRange hasRange = (HttpContentRange.HasRange)((Object)this.originalContentRange);
            ByteRangeSpec range = hasRange.range();
            long originalBegin = range.beginOffset();
            long contentOffset = offset - originalBegin;
            Preconditions.checkArgument(0L <= contentOffset && contentOffset < range.length(), "Rewind offset is out of bounds. (%s <= %s < %s)", (Object)originalBegin, (Object)offset, (Object)range.endOffset());
            this.content.rewindTo(contentOffset);
        } else {
            this.content.rewindTo(0L);
        }
        if (this.contentRange instanceof HttpContentRange.HasRange) {
            HttpContentRange.HasRange range = (HttpContentRange.HasRange)((Object)this.contentRange);
            this.contentRange = range.map(s -> s.withNewBeginOffset(offset));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResumableOperationResult<@Nullable StorageObject> call() throws IOException {
        span = this.context.startSpan(JsonResumableSession.SPAN_NAME_WRITE);
        scope = this.context.getTracer().withSpan(span);
        success = false;
        finalizing = this.originalContentRange.isFinalizing();
        req = this.context.getRequestFactory().buildPutRequest(new GenericUrl(this.uploadId), this.content).setParser(this.context.getObjectParser());
        req.setThrowExceptionOnExecuteError(false);
        req.getHeaders().setContentRange(this.contentRange.getHeaderValue());
        response = null;
        try {
            response = req.execute();
            code = response.getStatusCode();
            if (!finalizing && ResumableSessionFailureScenario.isContinue(code)) {
                effectiveEnd = ((HttpContentRange.HasRange)this.contentRange).range().endOffset();
                range = response.getHeaders().getRange();
                ackRange = ByteRangeSpec.parse(range);
                if (ackRange.endOffset() == effectiveEnd) {
                    success = true;
                    var12_24 = ResumableOperationResult.incremental(ackRange.endOffset());
                    return var12_24;
                }
                if (ackRange.endOffset() < effectiveEnd) {
                    this.rewindTo(ackRange.endOffset());
                    success = true;
                    var12_25 = ResumableOperationResult.incremental(ackRange.endOffset());
                    return var12_25;
                }
                se = ResumableSessionFailureScenario.SCENARIO_7.toStorageException(this.uploadId, response);
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
            if (!finalizing || !ResumableSessionFailureScenario.isOk(code)) ** GOTO lbl63
            actualSize = BigInteger.ZERO;
            contentLength = response.getHeaders().getContentLength();
            contentType = response.getHeaders().getContentType();
            storedContentLength = HttpClientContext.firstHeaderValue(response.getHeaders(), "x-goog-stored-content-length");
            v0 = isJson = contentType != null && contentType.startsWith("application/json") != false;
            if (isJson) {
                storageObject = response.parseAs(StorageObject.class);
                if (storageObject != null && (size = storageObject.getSize()) != null) {
                    actualSize = size;
                }
            } else if ((contentLength == null || contentLength == 0L) && storedContentLength != null) {
                response.ignore();
                actualSize = new BigInteger(storedContentLength, 10);
                success = true;
                storageObject = null;
            } else {
                response.ignore();
                se = ResumableSessionFailureScenario.SCENARIO_0_1.toStorageException(this.uploadId, response, null, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$1(), ()Ljava/lang/String;)());
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
            if ((compare = (expectedSize = BigInteger.valueOf(((HttpContentRange.HasSize)this.contentRange).getSize())).compareTo(actualSize)) == 0) {
                success = true;
                var16_36 = ResumableOperationResult.complete(storageObject, actualSize.longValue());
                return var16_36;
            }
            try {
                if (compare > 0) {
                    se = ResumableSessionFailureScenario.SCENARIO_4_1.toStorageException(this.uploadId, response, null, JsonResumableSessionPutTask.toString(storageObject));
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                se = ResumableSessionFailureScenario.SCENARIO_4_2.toStorageException(this.uploadId, response, null, JsonResumableSessionPutTask.toString(storageObject));
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
lbl63:
                // 1 sources

                if (!finalizing && ResumableSessionFailureScenario.isOk(code)) {
                    se = ResumableSessionFailureScenario.SCENARIO_1.toStorageException(this.uploadId, response);
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                if (finalizing && ResumableSessionFailureScenario.isContinue(code)) {
                    size = (HttpContentRange.HasSize)this.contentRange;
                    range = ByteRangeSpec.parse(response.getHeaders().getRange());
                    if (range.endOffsetInclusive() < size.getSize()) {
                        se = ResumableSessionFailureScenario.SCENARIO_3.toStorageException(this.uploadId, response);
                        span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                        throw se;
                    }
                    se = ResumableSessionFailureScenario.SCENARIO_2.toStorageException(this.uploadId, response);
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                cause = new HttpResponseException(response);
                contentType = response.getHeaders().getContentType();
                contentLength = response.getHeaders().getContentLength();
                if (!ResumableSessionFailureScenario.isOk(code) && !ResumableSessionFailureScenario.isContinue(code) && contentType != null && contentType.startsWith("text/plain") && contentLength != null && contentLength > 0L && (errorMessage = cause.getContent().toLowerCase(Locale.US)).contains("content-range") && !errorMessage.contains("earlier")) {
                    se = ResumableSessionFailureScenario.SCENARIO_5.toStorageException(this.uploadId, response, cause, (StorageException.IOExceptionCallable<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getContent(), ()Ljava/lang/String;)((HttpResponseException)cause));
                    span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                    throw se;
                }
                se = ResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
            catch (StorageException | IllegalArgumentException e) {
                span.setStatus(Status.UNKNOWN.withDescription(e.getMessage()));
                throw e;
            }
            catch (Exception e) {
                se = ResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.uploadId, response, e);
                span.setStatus(Status.UNKNOWN.withDescription(se.getMessage()));
                throw se;
            }
        }
        finally {
            if (success && !finalizing && response != null) {
                response.ignore();
            }
            scope.close();
            span.end(JsonResumableSession.END_SPAN_OPTIONS);
        }
    }

    static StorageException.IOExceptionCallable<@Nullable String> toString(@Nullable Object o) {
        return () -> o != null ? o.toString() : null;
    }

    private static /* synthetic */ String lambda$call$1() throws IOException {
        return null;
    }
}

