/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsCredentialsProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsCredentialsRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.client.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.client.BootstrapperImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.client.XdsInitializationException;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.client.XdsLogger;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class GrpcBootstrapperImpl
extends BootstrapperImpl {
    private static final String BOOTSTRAP_PATH_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP";
    private static final String BOOTSTRAP_PATH_SYS_PROPERTY = "com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.bootstrap";
    private static final String BOOTSTRAP_CONFIG_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP_CONFIG";
    private static final String BOOTSTRAP_CONFIG_SYS_PROPERTY = "com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.bootstrapConfig";
    @VisibleForTesting
    String bootstrapPathFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP");
    @VisibleForTesting
    String bootstrapPathFromSysProp = System.getProperty("com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.bootstrap");
    @VisibleForTesting
    String bootstrapConfigFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP_CONFIG");
    @VisibleForTesting
    String bootstrapConfigFromSysProp = System.getProperty("com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.bootstrapConfig");

    GrpcBootstrapperImpl() {
    }

    @Override
    public Bootstrapper.BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        return super.bootstrap(rawData);
    }

    @Override
    protected String getJsonContent() throws XdsInitializationException, IOException {
        String jsonContent;
        String filePath;
        String string = filePath = this.bootstrapPathFromEnvVar != null ? this.bootstrapPathFromEnvVar : this.bootstrapPathFromSysProp;
        if (filePath != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap file from {0}", filePath);
            jsonContent = this.reader.readFile(filePath);
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap from " + filePath, new Object[0]);
        } else {
            String string2 = jsonContent = this.bootstrapConfigFromEnvVar != null ? this.bootstrapConfigFromEnvVar : this.bootstrapConfigFromSysProp;
        }
        if (jsonContent == null) {
            throw new XdsInitializationException("Cannot find bootstrap configuration\nEnvironment variables searched:\n- GRPC_XDS_BOOTSTRAP\n- GRPC_XDS_BOOTSTRAP_CONFIG\n\nJava System Properties searched:\n- io.grpc.xds.bootstrap\n- io.grpc.xds.bootstrapConfig\n\n");
        }
        return jsonContent;
    }

    @Override
    protected Object getImplSpecificConfig(Map<String, ?> serverConfig, String serverUri) throws XdsInitializationException {
        return GrpcBootstrapperImpl.getChannelCredentials(serverConfig, serverUri);
    }

    private static ChannelCredentials getChannelCredentials(Map<String, ?> serverConfig, String serverUri) throws XdsInitializationException {
        List<?> rawChannelCredsList = JsonUtil.getList(serverConfig, "channel_creds");
        if (rawChannelCredsList == null || rawChannelCredsList.isEmpty()) {
            throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " 'channel_creds' required");
        }
        ChannelCredentials channelCredentials = GrpcBootstrapperImpl.parseChannelCredentials(JsonUtil.checkObjectList(rawChannelCredsList), serverUri);
        if (channelCredentials == null) {
            throw new XdsInitializationException("Server " + serverUri + ": no supported channel credentials found");
        }
        return channelCredentials;
    }

    @Nullable
    private static ChannelCredentials parseChannelCredentials(List<Map<String, ?>> jsonList, String serverUri) throws XdsInitializationException {
        for (Map<String, ?> channelCreds : jsonList) {
            String type = JsonUtil.getString(channelCreds, "type");
            if (type == null) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " with 'channel_creds' type unspecified");
            }
            XdsCredentialsProvider provider = XdsCredentialsRegistry.getDefaultRegistry().getProvider(type);
            if (provider == null) continue;
            Map<String, ?> config = JsonUtil.getObject(channelCreds, "config");
            if (config == null) {
                config = ImmutableMap.of();
            }
            return provider.newChannelCredentials(config);
        }
        return null;
    }
}

