/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.vertica;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcJoinPushdownSupportModule;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.vertica.VerticaClient;
import io.trino.plugin.vertica.VerticaDriver;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.sql.Driver;

public class VerticaClientModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(VerticaClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(VerticaClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcStatisticsConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(JdbcStatisticsConfig.class, config -> config.setEnabled(false));
        binder.install((Module)new DecimalModule());
        this.install((Module)new JdbcJoinPushdownSupportModule());
        Class<ConnectorTableFunction> clazz = ConnectorTableFunction.class;
        Multibinder.newSetBinder((Binder)binder, clazz).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory createConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        return DriverConnectionFactory.builder((Driver)((Object)new VerticaDriver()), (String)config.getConnectionUrl(), (CredentialProvider)credentialProvider).setOpenTelemetry(openTelemetry).build();
    }
}

