/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

public class MatchContext {
    private final Map<String, Object> resolved = new HashMap<String, Object>();

    public void record(String name, Object value) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        this.resolved.merge(name, value, MatchContext.checkEqual(name));
    }

    public Object get(String name) {
        Object value = this.resolved.get(name);
        if (value == null) {
            throw new IllegalStateException("No value recorded for: " + name);
        }
        return value;
    }

    public Optional<Object> getIfPresent(String name) {
        return Optional.ofNullable(this.resolved.get(name));
    }

    @VisibleForTesting
    Set<String> keys() {
        return ImmutableSet.copyOf(this.resolved.keySet());
    }

    private static BiFunction<Object, Object, Object> checkEqual(String name) {
        return (first, second) -> {
            if (first.equals(second)) {
                return first;
            }
            throw new IllegalStateException(String.format("%s is already mapped to %s, cannot remap to %s", name, first, second));
        };
    }
}

