/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.redis.RedisConnector;
import io.trino.plugin.redis.RedisConnectorModule;
import io.trino.plugin.redis.RedisTableDescription;
import io.trino.plugin.redis.RedisTableDescriptionSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class RedisConnectorFactory
implements ConnectorFactory {
    private final Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier;

    RedisConnectorFactory(Optional<Supplier<Map<SchemaTableName, RedisTableDescription>>> tableDescriptionSupplier) {
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
    }

    public String getName() {
        return "redis";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new RedisConnectorModule(), binder -> {
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            if (this.tableDescriptionSupplier.isPresent()) {
                binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, RedisTableDescription>>>(this){}).toInstance(this.tableDescriptionSupplier.get());
            } else {
                binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, RedisTableDescription>>>(this){}).to(RedisTableDescriptionSupplier.class).in(Scopes.SINGLETON);
            }
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(RedisConnector.class);
    }
}

