/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.collect.ImmutableList;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.RowDecoder;
import io.trino.plugin.redis.RedisColumnHandle;
import io.trino.plugin.redis.RedisJedisManager;
import io.trino.plugin.redis.RedisRecordCursor;
import io.trino.plugin.redis.RedisSplit;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class RedisRecordSet
implements RecordSet {
    private final RedisSplit split;
    private final RedisJedisManager jedisManager;
    private final RowDecoder keyDecoder;
    private final RowDecoder valueDecoder;
    private final List<RedisColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    RedisRecordSet(RedisSplit split, RedisJedisManager jedisManager, List<RedisColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder valueDecoder) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "keyDecoder is null");
        this.valueDecoder = Objects.requireNonNull(valueDecoder, "valueDecoder is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (DecoderColumnHandle decoderColumnHandle : columnHandles) {
            typeBuilder.add((Object)decoderColumnHandle.getType());
        }
        this.columnTypes = typeBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new RedisRecordCursor(this.keyDecoder, this.valueDecoder, this.split, this.columnHandles, this.jedisManager);
    }
}

