/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.google.common.base.Joiner;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.trino.geospatial.GeometryType;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.util.EnumSet;
import java.util.Set;

public final class EncodedPolylineFunctions {
    private EncodedPolylineFunctions() {
    }

    @Description(value="Decodes a polyline to a linestring")
    @ScalarFunction(value="from_encoded_polyline")
    @SqlType(value="Geometry")
    public static Slice fromEncodedPolyline(@SqlType(value="varchar") Slice input) {
        return GeometrySerde.serialize((OGCGeometry)EncodedPolylineFunctions.decodePolyline(input.toStringUtf8()));
    }

    private static OGCLineString decodePolyline(String polyline) {
        Polyline multipath = new Polyline();
        boolean isFirstPoint = true;
        int index = 0;
        int latitude = 0;
        int longitude = 0;
        while (index < polyline.length()) {
            int bytes;
            int result = 1;
            int shift = 0;
            do {
                bytes = polyline.charAt(index++) - 63 - 1;
                result += bytes << shift;
                shift += 5;
            } while (bytes >= 31);
            latitude += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                bytes = polyline.charAt(index++) - 63 - 1;
                result += bytes << shift;
                shift += 5;
            } while (bytes >= 31);
            longitude += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            if (isFirstPoint) {
                multipath.startPath((double)longitude * 1.0E-5, (double)latitude * 1.0E-5);
                isFirstPoint = false;
                continue;
            }
            multipath.lineTo((double)longitude * 1.0E-5, (double)latitude * 1.0E-5);
        }
        return new OGCLineString((MultiPath)multipath, 0, null);
    }

    @Description(value="Encodes a linestring or multipoint geometry to a polyline")
    @ScalarFunction(value="to_encoded_polyline")
    @SqlType(value="varchar")
    public static Slice toEncodedPolyline(@SqlType(value="Geometry") Slice input) {
        OGCGeometry geometry = GeometrySerde.deserialize((Slice)input);
        EncodedPolylineFunctions.validateType("encode_polyline", geometry, EnumSet.of(GeometryType.LINE_STRING, GeometryType.MULTI_POINT));
        GeometryType geometryType = GeometryType.getForEsriGeometryType((String)geometry.geometryType());
        switch (geometryType) {
            case LINE_STRING: 
            case MULTI_POINT: {
                break;
            }
            default: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Unexpected geometry type: " + String.valueOf(geometryType));
            }
        }
        return EncodedPolylineFunctions.encodePolyline((MultiVertexGeometry)geometry.getEsriGeometry());
    }

    private static Slice encodePolyline(MultiVertexGeometry multiVertexGeometry) {
        long lastLatitude = 0L;
        long lastLongitude = 0L;
        DynamicSliceOutput output = new DynamicSliceOutput(0);
        for (int i = 0; i < multiVertexGeometry.getPointCount(); ++i) {
            Point point = multiVertexGeometry.getPoint(i);
            long latitude = Math.round(point.getY() * 100000.0);
            long longitude = Math.round(point.getX() * 100000.0);
            long latitudeDelta = latitude - lastLatitude;
            long longitudeDelta = longitude - lastLongitude;
            EncodedPolylineFunctions.encode(latitudeDelta, output);
            EncodedPolylineFunctions.encode(longitudeDelta, output);
            lastLatitude = latitude;
            lastLongitude = longitude;
        }
        return output.slice();
    }

    private static void encode(long value, DynamicSliceOutput output) {
        long l = value = value < 0L ? value << 1 ^ 0xFFFFFFFFFFFFFFFFL : value << 1;
        while (value >= 32L) {
            output.appendByte((int)((byte)((0x20L | value & 0x1FL) + 63L)));
            value >>= 5;
        }
        output.appendByte((int)((byte)(value + 63L)));
    }

    private static void validateType(String function, OGCGeometry geometry, Set<GeometryType> validTypes) {
        GeometryType type = GeometryType.getForEsriGeometryType((String)geometry.geometryType());
        if (!validTypes.contains(type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("%s only applies to %s. Input type is: %s", function, Joiner.on((String)" or ").join(validTypes), type));
        }
    }
}

