/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.RowDecoderSpec;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;

public class DispatchingRowDecoderFactory {
    private final Map<String, RowDecoderFactory> factories;

    @Inject
    public DispatchingRowDecoderFactory(Map<String, RowDecoderFactory> factories) {
        this.factories = ImmutableMap.copyOf(factories);
    }

    public RowDecoder create(ConnectorSession session, RowDecoderSpec rowDecoderSpec) {
        Preconditions.checkArgument((boolean)this.factories.containsKey(rowDecoderSpec.dataFormat()), (String)"unknown data format '%s'", (Object)rowDecoderSpec.dataFormat());
        return this.factories.get(rowDecoderSpec.dataFormat()).create(session, rowDecoderSpec);
    }
}

