/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.amazon.redshift.jdbc.RedshiftPreparedStatement;
import com.amazon.redshift.util.RedshiftObject;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.projection.ProjectFunctionRewriter;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcJoinPushdownUtil;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementCountDistinct;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementStddevPop;
import io.trino.plugin.jdbc.aggregation.ImplementStddevSamp;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.aggregation.ImplementVariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementVarianceSamp;
import io.trino.plugin.jdbc.expression.ComparisonOperator;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.expression.RewriteComparison;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.redshift.ImplementRedshiftAvgBigint;
import io.trino.plugin.redshift.ImplementRedshiftAvgDecimal;
import io.trino.plugin.redshift.RedshiftConfig;
import io.trino.plugin.redshift.RedshiftErrorCode;
import io.trino.plugin.redshift.RedshiftTableStatisticsReader;
import io.trino.plugin.redshift.RewriteCast;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class RedshiftClient
extends BaseJdbcClient {
    private static final int REDSHIFT_DECIMAL_CUTOFF_PRECISION = 19;
    static final int REDSHIFT_MAX_DECIMAL_PRECISION = 38;
    private static final int REDSHIFT_DECIMAL_CUTOFF_BITS = BigInteger.valueOf(Long.MAX_VALUE).bitLength();
    private static final int REDSHIFT_MAX_CHAR = 4096;
    static final int REDSHIFT_MAX_VARCHAR = 65535;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyy-MM-dd[ G]");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyy-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd().appendPattern("[ G]").toFormatter();
    private static final OffsetDateTime REDSHIFT_MIN_SUPPORTED_TIMESTAMP_TZ = OffsetDateTime.of(-4712, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private final ProjectFunctionRewriter<JdbcExpression, ParameterizedExpression> projectFunctionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;
    private final boolean statisticsEnabled;
    private final RedshiftTableStatisticsReader statisticsReader;
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((RedshiftClient)this).quoted(arg_0)).add((ConnectorExpressionRule)new RewriteComparison((Set)ImmutableSet.of((Object)ComparisonOperator.EQUAL, (Object)ComparisonOperator.NOT_EQUAL))).map("$less_than(left, right)").to("left < right").map("$less_than_or_equal(left, right)").to("left <= right").map("$greater_than(left, right)").to("left > right").map("$greater_than_or_equal(left, right)").to("left >= right").build();
    private final Optional<Integer> fetchSize;

    @Inject
    public RedshiftClient(BaseJdbcConfig config, RedshiftConfig redshiftConfig, ConnectionFactory connectionFactory, JdbcStatisticsConfig statisticsConfig, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, true);
        this.projectFunctionRewriter = new ProjectFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new RewriteCast((session, type) -> this.toWriteMapping((ConnectorSession)session, (Type)type).getDataType())).build());
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementCountDistinct(bigintTypeHandle, true)).add((Object)new ImplementMinMax(true)).add((Object)new ImplementSum(RedshiftClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementRedshiftAvgDecimal()).add((Object)new ImplementRedshiftAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).build());
        this.statisticsEnabled = Objects.requireNonNull(statisticsConfig, "statisticsConfig is null").isEnabled();
        this.statisticsReader = new RedshiftTableStatisticsReader(connectionFactory);
        this.fetchSize = redshiftConfig.getFetchSize();
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcTableHandle tableHandle) throws SQLException {
        Connection connection = super.getConnection(session, split, tableHandle);
        try {
            connection.setReadOnly(false);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    protected ResultSet getAllTableColumns(Connection connection, Optional<String> remoteSchemaName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getColumns(metadata.getConnection().getCatalog(), this.escapeObjectNameForMetadataQuery(remoteSchemaName, metadata.getSearchStringEscape()).orElse(null), null, null);
    }

    protected void dropSchema(ConnectorSession session, Connection connection, String remoteSchemaName, boolean cascade) throws SQLException {
        if (cascade) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas with CASCADE option");
        }
        this.execute(session, connection, "DROP SCHEMA " + this.quoted(remoteSchemaName));
    }

    protected List<String> createTableSqls(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        ImmutableList.Builder createTableSqlsBuilder = ImmutableList.builder();
        createTableSqlsBuilder.add((Object)String.format("CREATE TABLE %s (%s)", this.quoted(remoteTableName), String.join((CharSequence)", ", columns)));
        Optional tableComment = tableMetadata.getComment();
        if (tableComment.isPresent()) {
            createTableSqlsBuilder.add((Object)this.buildTableCommentSql(remoteTableName, tableComment));
        }
        return createTableSqlsBuilder.build();
    }

    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        this.execute(session, this.buildTableCommentSql(handle.asPlainTable().getRemoteTableName(), comment));
    }

    private String buildTableCommentSql(RemoteTableName remoteTableName, Optional<String> tableComment) {
        return String.format("COMMENT ON TABLE %s IS %s", this.quoted(remoteTableName), tableComment.map(RedshiftClient::redshiftVarcharLiteral).orElse("NULL"));
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public Optional<JdbcExpression> convertProjection(ConnectorSession session, JdbcTableHandle handle, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.projectFunctionRewriter.rewrite(session, (ConnectorTableHandle)handle, expression, assignments);
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        if (!this.statisticsEnabled) {
            return TableStatistics.empty();
        }
        if (!handle.isNamedRelation()) {
            return TableStatistics.empty();
        }
        try {
            return this.statisticsReader.readTableStatistics(session, handle, () -> JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this, (JdbcTableHandle)handle));
        }
        catch (RuntimeException | SQLException e) {
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed fetching statistics for table: " + String.valueOf(handle), (Throwable)e);
        }
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().map(sortItem -> {
                String ordering = sortItem.sortOrder().isAscending() ? "ASC" : "DESC";
                String nullsHandling = sortItem.sortOrder().isNullsFirst() ? "NULLS FIRST" : "NULLS LAST";
                return String.format("%s %s %s", this.quoted(sortItem.column().getColumnName()), ordering, nullsHandling);
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %d", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return joinCondition.getOperator() != JoinCondition.Operator.IDENTICAL;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return JdbcJoinPushdownUtil.implementJoinCostAware((ConnectorSession)session, (JoinType)joinType, (PreparedQuery)leftSource, (PreparedQuery)rightSource, (JoinStatistics)statistics, () -> super.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics));
    }

    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return JdbcJoinPushdownUtil.implementJoinCostAware((ConnectorSession)session, (JoinType)joinType, (PreparedQuery)leftSource, (PreparedQuery)rightSource, (JoinStatistics)statistics, () -> super.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics));
    }

    protected void renameTable(ConnectorSession session, Connection connection, String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) throws SQLException {
        if (!remoteSchemaName.equals(newRemoteSchemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        this.execute(session, connection, String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, remoteSchemaName, remoteTableName), this.quoted(newRemoteTableName)));
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        Optional<Integer> fetchSize = Optional.ofNullable(this.fetchSize.orElseGet(() -> columnCount.map(count -> Math.max(100000 / count, 1000)).orElse(null)));
        if (fetchSize.isPresent()) {
            statement.setFetchSize(fetchSize.get());
        }
        return statement;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to delete from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to delete when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to delete when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getUpdateAssignments().isEmpty(), (String)"Unable to delete when update assignments are set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareDeleteQuery((JdbcClient)this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), Optional.empty());
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.empty());
                try {
                    int affectedRowsCount = preparedStatement.executeUpdate();
                    connection.commit();
                    optionalLong = OptionalLong.of(affectedRowsCount);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to update from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to update when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to update when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((!handle.getUpdateAssignments().isEmpty() ? 1 : 0) != 0, (String)"Unable to update when update assignments are not set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareUpdateQuery((JdbcClient)this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), RedshiftClient.getAdditionalPredicate((List)handle.getConstraintExpressions(), Optional.empty()), handle.getUpdateAssignments());
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.empty());
                try {
                    int affectedRows = preparedStatement.executeUpdate();
                    connection.commit();
                    optionalLong = OptionalLong.of(affectedRows);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public OptionalInt getMaxColumnNameLength(ConnectorSession session) {
        return this.getMaxColumnNameLengthFromDatabaseMetaData(session);
    }

    protected void addColumn(ConnectorSession session, Connection connection, RemoteTableName table, ColumnMetadata column) throws SQLException {
        if (!column.isNullable()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding not null columns");
        }
        super.addColumn(session, connection, table, column);
    }

    protected void verifySchemaName(DatabaseMetaData databaseMetadata, String schemaName) throws SQLException {
        if (schemaName.length() > databaseMetadata.getMaxSchemaNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Schema name must be shorter than or equal to '%d' characters but got '%d'".formatted(databaseMetadata.getMaxSchemaNameLength(), schemaName.length()));
        }
    }

    protected void verifyTableName(DatabaseMetaData databaseMetadata, String tableName) throws SQLException {
        if (tableName.length() > databaseMetadata.getMaxTableNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table name must be shorter than or equal to '%d' characters but got '%d'".formatted(databaseMetadata.getMaxTableNameLength(), tableName.length()));
        }
    }

    protected void verifyColumnName(DatabaseMetaData databaseMetadata, String columnName) throws SQLException {
        if (columnName.length() > databaseMetadata.getMaxColumnNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Column name must be shorter than or equal to '%d' characters but got '%d'".formatted(databaseMetadata.getMaxColumnNameLength(), columnName.length()));
        }
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle type) {
        Optional mapping = this.getForcedMappingToVarchar(type);
        if (mapping.isPresent()) {
            return mapping;
        }
        if ("time".equals(type.jdbcTypeName().orElse(""))) {
            return Optional.of(ColumnMapping.longMapping((Type)TimeType.TIME_MICROS, RedshiftClient::readTime, RedshiftClient::writeTime));
        }
        switch (type.jdbcType()) {
            case -7: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case 5: {
                return Optional.of(ColumnMapping.longMapping((Type)SmallintType.SMALLINT, ResultSet::getShort, (LongWriteFunction)StandardColumnMappings.smallintWriteFunction(), (PredicatePushdownController)PredicatePushdownController.pushdownDiscreteValues((Type)SmallintType.SMALLINT)));
            }
            case 4: {
                return Optional.of(ColumnMapping.longMapping((Type)IntegerType.INTEGER, ResultSet::getInt, (LongWriteFunction)StandardColumnMappings.integerWriteFunction(), (PredicatePushdownController)PredicatePushdownController.pushdownDiscreteValues((Type)IntegerType.INTEGER)));
            }
            case -5: {
                return Optional.of(ColumnMapping.longMapping((Type)BigintType.BIGINT, ResultSet::getLong, (LongWriteFunction)StandardColumnMappings.bigintWriteFunction(), (PredicatePushdownController)PredicatePushdownController.pushdownDiscreteValues((Type)BigintType.BIGINT)));
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: {
                int precision = type.requiredColumnSize();
                int scale = type.requiredDecimalDigits();
                DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
                if (precision == 19) {
                    return Optional.of(ColumnMapping.objectMapping((Type)decimalType, (ObjectReadFunction)StandardColumnMappings.longDecimalReadFunction((DecimalType)decimalType), (ObjectWriteFunction)RedshiftClient.writeDecimalAtRedshiftCutoff(scale)));
                }
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)decimalType, (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case 1: {
                CharType charType = CharType.createCharType((int)type.requiredColumnSize());
                return Optional.of(ColumnMapping.sliceMapping((Type)charType, (SliceReadFunction)StandardColumnMappings.charReadFunction((CharType)charType), RedshiftClient::writeChar));
            }
            case 12: {
                if (type.columnSize().isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)RedshiftErrorCode.REDSHIFT_INVALID_TYPE, "column size not present");
                }
                int length = type.requiredColumnSize();
                return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)(length < 0x7FFFFFFE ? VarcharType.createVarcharType((int)length) : VarcharType.createUnboundedVarcharType()), (boolean)true));
            }
            case -4: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (SliceReadFunction)StandardColumnMappings.varbinaryReadFunction(), (SliceWriteFunction)RedshiftClient.varbinaryWriteFunction()));
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, RedshiftClient::readDate, RedshiftClient::writeDate));
            }
            case 93: {
                return Optional.of(ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP_MICROS, RedshiftClient::readTimestamp, RedshiftClient::writeShortTimestamp));
            }
            case 2014: {
                return Optional.of(ColumnMapping.objectMapping((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, (ObjectReadFunction)RedshiftClient.longTimestampWithTimeZoneReadFunction(), (ObjectWriteFunction)RedshiftClient.longTimestampWithTimeZoneWriteFunction()));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return RedshiftClient.mapToUnboundedVarchar((JdbcTypeHandle)type);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (RealType.REAL.equals((Object)type)) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimal = (DecimalType)type;
            if (decimal.getPrecision() == 19) {
                return WriteMapping.objectMapping((String)String.format("decimal(%s, %s)", decimal.getPrecision(), decimal.getScale()), (ObjectWriteFunction)RedshiftClient.writeDecimalAtRedshiftCutoff(decimal.getScale()));
            }
            String name = String.format("decimal(%s, %s)", decimal.getPrecision(), decimal.getScale());
            return decimal.isShort() ? WriteMapping.longMapping((String)name, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimal)) : WriteMapping.objectMapping((String)name, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimal));
        }
        if (type instanceof CharType) {
            int size = ((CharType)type).getLength();
            if (size <= 4096) {
                return WriteMapping.sliceMapping((String)String.format("char(%d)", size), RedshiftClient::writeChar);
            }
            int redshiftVarcharWidth = Math.min(size, 65535);
            return WriteMapping.sliceMapping((String)String.format("varchar(%d)", redshiftVarcharWidth), (statement, index, value) -> RedshiftClient.writeCharAsVarchar(statement, index, value, redshiftVarcharWidth));
        }
        if (type instanceof VarcharType) {
            int size = ((VarcharType)type).getLength().filter(n -> n <= 65535).orElse(65535);
            return WriteMapping.sliceMapping((String)String.format("varchar(%d)", size), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"varbyte", (SliceWriteFunction)RedshiftClient.varbinaryWriteFunction());
        }
        if (DateType.DATE.equals((Object)type)) {
            return WriteMapping.longMapping((String)"date", RedshiftClient::writeDate);
        }
        if (type instanceof TimeType) {
            return WriteMapping.longMapping((String)"time", RedshiftClient::writeTime);
        }
        if (type instanceof TimestampType) {
            if (((TimestampType)type).isShort()) {
                return WriteMapping.longMapping((String)"timestamp", RedshiftClient::writeShortTimestamp);
            }
            return WriteMapping.objectMapping((String)"timestamp", LongTimestamp.class, RedshiftClient::writeLongTimestamp);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            if (timestampWithTimeZoneType.getPrecision() <= 3) {
                return WriteMapping.longMapping((String)"timestamptz", (LongWriteFunction)RedshiftClient.shortTimestampWithTimeZoneWriteFunction());
            }
            return WriteMapping.objectMapping((String)"timestamptz", (ObjectWriteFunction)RedshiftClient.longTimestampWithTimeZoneWriteFunction());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("COMMENT ON COLUMN %s.%s IS %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(column.getColumnName()), comment.map(RedshiftClient::redshiftVarcharLiteral).orElse("NULL"));
        this.execute(session, sql);
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropNotNullConstraint(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping a not null constraint");
    }

    private static String redshiftVarcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''").replace("\\", "\\\\") + "'";
    }

    private static ObjectReadFunction longTimestampWithTimeZoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)offsetDateTime.toEpochSecond(), (long)((long)offsetDateTime.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
        });
    }

    private static LongWriteFunction shortTimestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            long epochSeconds = Math.floorDiv(millisUtc, 1000);
            int nanosOfSecond = Math.floorMod(millisUtc, 1000) * 1000000;
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId());
            RedshiftClient.verifySupportedTimestampWithTimeZone(offsetDateTime);
            statement.setObject(index, offsetDateTime);
        };
    }

    private static ObjectWriteFunction longTimestampWithTimeZoneWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochSeconds = Math.floorDiv(value.getEpochMillis(), 1000);
            long nanosOfSecond = (long)Math.floorMod(value.getEpochMillis(), 1000) * 1000000L + (long)(value.getPicosOfMilli() / 1000);
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId());
            RedshiftClient.verifySupportedTimestampWithTimeZone(offsetDateTime);
            statement.setObject(index, offsetDateTime);
        });
    }

    private static void verifySupportedTimestampWithTimeZone(OffsetDateTime value) {
        if (value.isBefore(REDSHIFT_MIN_SUPPORTED_TIMESTAMP_TZ)) {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSSSS");
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Minimum timestamp with time zone in Redshift is %s: %s", REDSHIFT_MIN_SUPPORTED_TIMESTAMP_TZ.format(format), value.format(format)));
        }
    }

    private static ObjectWriteFunction writeDecimalAtRedshiftCutoff(int scale) {
        return ObjectWriteFunction.of(Int128.class, (statement, index, decimal) -> {
            BigInteger unscaled = decimal.toBigInteger();
            if (unscaled.bitLength() > REDSHIFT_DECIMAL_CUTOFF_BITS) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, String.format("Value out of range for Redshift DECIMAL(%d, %d)", 19, scale));
            }
            MathContext precision = new MathContext(19);
            statement.setBigDecimal(index, new BigDecimal(unscaled, scale, precision));
        });
    }

    private static void writeChar(PreparedStatement statement, int index, Slice slice) throws SQLException {
        String value = slice.toStringUtf8();
        if (!CharMatcher.ascii().matchesAllOf((CharSequence)value)) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, String.format("Value for Redshift CHAR must be ASCII, but found '%s'", value));
        }
        statement.setString(index, slice.toStringAscii());
    }

    private static void writeCharAsVarchar(PreparedStatement statement, int index, Slice slice, int columnLength) throws SQLException {
        statement.setString(index, Chars.padSpaces((Slice)slice, (int)columnLength).toStringUtf8());
    }

    private static void writeDate(PreparedStatement statement, int index, long day) throws SQLException {
        statement.setObject(index, new RedshiftObject("date", DATE_FORMATTER.format(LocalDate.ofEpochDay(day))));
    }

    private static long readDate(ResultSet results, int index) throws SQLException {
        return LocalDate.parse(results.getString(index), DATE_FORMATTER).toEpochDay();
    }

    private static void writeTime(PreparedStatement statement, int index, long picos) throws SQLException {
        statement.setObject(index, LocalTime.ofNanoOfDay(Timestamps.roundDiv((long)picos, (long)1000000L) % 86400000000L * 1000L));
    }

    private static long readTime(ResultSet results, int index) throws SQLException {
        return results.getObject(index, LocalTime.class).toNanoOfDay() * 1000L;
    }

    private static void writeShortTimestamp(PreparedStatement statement, int index, long epochMicros) throws SQLException {
        statement.setObject(index, new RedshiftObject("timestamp", DATE_TIME_FORMATTER.format(StandardColumnMappings.fromTrinoTimestamp((long)epochMicros))));
    }

    private static void writeLongTimestamp(PreparedStatement statement, int index, Object value) throws SQLException {
        LongTimestamp timestamp = (LongTimestamp)value;
        long epochMicros = timestamp.getEpochMicros();
        if (timestamp.getPicosOfMicro() >= 500000) {
            ++epochMicros;
        }
        statement.setObject(index, new RedshiftObject("timestamp", DATE_TIME_FORMATTER.format(StandardColumnMappings.fromTrinoTimestamp((long)epochMicros))));
    }

    private static long readTimestamp(ResultSet results, int index) throws SQLException {
        return StandardColumnMappings.toTrinoTimestamp((TimestampType)TimestampType.TIMESTAMP_MICROS, (LocalDateTime)results.getObject(index, LocalDateTime.class));
    }

    private static SliceWriteFunction varbinaryWriteFunction() {
        return (statement, index, value) -> statement.unwrap(RedshiftPreparedStatement.class).setVarbyte(index, value.getBytes());
    }
}

