/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.util.Optional;

@DefunctConfig(value={"redshift.disable-automatic-fetch-size", "redshift.use-legacy-type-mapping"})
public class RedshiftConfig {
    private Integer fetchSize;
    private String unloadLocation;
    private String unloadIamRole;

    public Optional<@Min(value=0L) Integer> getFetchSize() {
        return Optional.ofNullable(this.fetchSize);
    }

    @Config(value="redshift.fetch-size")
    @ConfigDescription(value="Redshift fetch size, trino specific heuristic is applied if empty")
    public RedshiftConfig setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public Optional<@Pattern(regexp="^s3://[^/]+(/[^/]+)?$", message="Path shouldn't end with trailing slash") String> getUnloadLocation() {
        return Optional.ofNullable(this.unloadLocation);
    }

    @Config(value="redshift.unload-location")
    @ConfigDescription(value="A writeable location in Amazon S3, to be used for unloading Redshift query results")
    public RedshiftConfig setUnloadLocation(String unloadLocation) {
        this.unloadLocation = unloadLocation;
        return this;
    }

    public Optional<String> getUnloadIamRole() {
        return Optional.ofNullable(this.unloadIamRole);
    }

    @Config(value="redshift.unload-iam-role")
    @ConfigDescription(value="Fully specified ARN of the IAM Role attached to the Redshift cluster and having access to S3")
    public RedshiftConfig setUnloadIamRole(String unloadIamRole) {
        this.unloadIamRole = unloadIamRole;
        return this;
    }
}

