/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.Versions;
import io.trino.plugin.jdbc.ExtraCredentialsBasedIdentityCacheMappingModule;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.credential.CredentialProviderModule;
import io.trino.plugin.redshift.RedshiftClientModule;
import io.trino.spi.NodeManager;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class RedshiftConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "redshift";
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager()), binder -> binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager()), binder -> binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder()), binder -> binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry()), binder -> binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName)), new JdbcModule(), new CredentialProviderModule(), new ExtraCredentialsBasedIdentityCacheMappingModule(), new RedshiftClientModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(Connector.class);
    }
}

