/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.parquet.Column;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.parquet.metadata.PrunedBlockMetadata;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.parquet.reader.RowGroupInfo;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.redshift.RedshiftErrorCode;
import io.trino.plugin.redshift.RedshiftParquetPageSource;
import io.trino.plugin.redshift.RedshiftUnloadSplit;
import io.trino.plugin.redshift.TrinoParquetDataSource;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

public class RedshiftPageSourceProvider
implements ConnectorPageSourceProvider {
    private final ConnectorRecordSetProvider recordSetProvider;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;

    public RedshiftPageSourceProvider(ConnectorRecordSetProvider recordSetProvider, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats fileFormatDataSourceStats) {
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        ParquetReader parquetReader;
        if (split instanceof JdbcSplit) {
            return new RecordPageSource(this.recordSetProvider.getRecordSet(transaction, session, split, table, columns));
        }
        RedshiftUnloadSplit redshiftUnloadSplit = (RedshiftUnloadSplit)split;
        String path = redshiftUnloadSplit.path();
        Location location = Location.of((String)path);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        TrinoInputFile inputFile = fileSystem.newInputFile(location, redshiftUnloadSplit.length());
        try {
            parquetReader = this.parquetReader(inputFile, columns);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RedshiftErrorCode.REDSHIFT_PARQUET_CURSOR_ERROR, String.format("Failed to open Parquet file: %s", path), (Throwable)e);
        }
        return new RedshiftParquetPageSource(parquetReader);
    }

    private ParquetReader parquetReader(TrinoInputFile inputFile, List<ColumnHandle> columns) throws IOException {
        ParquetReaderOptions options = new ParquetReaderOptions();
        TrinoParquetDataSource dataSource = new TrinoParquetDataSource(inputFile, options, this.fileFormatDataSourceStats);
        ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
        MessageType fileSchema = parquetMetadata.getFileMetaData().getSchema();
        MessageColumnIO messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)fileSchema);
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        DateTimeZone timeZone = DateTimeZone.UTC;
        List<Column> fields = RedshiftPageSourceProvider.fields(columns, messageColumn);
        long nextStart = 0L;
        ImmutableList.Builder rowGroupInfoBuilder = ImmutableList.builder();
        for (BlockMetadata block : parquetMetadata.getBlocks()) {
            rowGroupInfoBuilder.add((Object)new RowGroupInfo(PrunedBlockMetadata.createPrunedColumnsMetadata((BlockMetadata)block, (ParquetDataSourceId)dataSource.getId(), (Map)descriptorsByPath), nextStart, Optional.empty()));
            nextStart += block.rowCount();
        }
        return new ParquetReader(Optional.ofNullable(parquetMetadata.getFileMetaData().getCreatedBy()), fields, (List)rowGroupInfoBuilder.build(), (ParquetDataSource)dataSource, timeZone, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), options, RedshiftParquetPageSource::handleException, Optional.empty(), Optional.empty());
    }

    private static List<Column> fields(List<ColumnHandle> columns, MessageColumnIO messageColumn) {
        ImmutableList.Builder parquetColumnFieldsBuilder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            JdbcColumnHandle jdbcColumn = (JdbcColumnHandle)column;
            ParquetTypeUtils.constructField((Type)jdbcColumn.getColumnType(), (ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)jdbcColumn.getColumnName())).ifPresent(field -> parquetColumnFieldsBuilder.add((Object)new Column(jdbcColumn.getColumnName(), field)));
        }
        return parquetColumnFieldsBuilder.build();
    }
}

