/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.redshift.RedshiftErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.OptionalLong;

public class RedshiftParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private boolean closed;
    private long completedPositions;

    public RedshiftParquetPageSource(ParquetReader parquetReader) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        Page page;
        try {
            page = this.parquetReader.nextPage();
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw RedshiftParquetPageSource.handleException(e);
        }
        if (this.closed || page == null) {
            this.close();
            return null;
        }
        this.completedPositions += (long)page.getPositionCount();
        return page;
    }

    public long getMemoryUsage() {
        return this.parquetReader.getMemoryContext().getBytes();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Metrics getMetrics() {
        return this.parquetReader.getMetrics();
    }

    static TrinoException handleException(Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)exception;
        }
        if (exception instanceof ParquetCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)RedshiftErrorCode.REDSHIFT_PARQUET_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)RedshiftErrorCode.REDSHIFT_PARQUET_CURSOR_ERROR, exception.getMessage(), (Throwable)exception);
    }
}

