/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.redshift.RedshiftConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public class RedshiftSessionProperties
implements SessionPropertiesProvider {
    private static final String UNLOAD_ENABLED = "unload_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public RedshiftSessionProperties(RedshiftConfig config) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)UNLOAD_ENABLED, (String)"Use UNLOAD for reading query results", (Boolean)config.getUnloadLocation().isPresent(), value -> {
            if (value.booleanValue() && config.getUnloadLocation().isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Cannot use UNLOAD when unload location is not configured");
            }
        }, (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isUnloadEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(UNLOAD_ENABLED, Boolean.class);
    }
}

