/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redshift;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.FileSystemS3;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.redshift.RedshiftConfig;
import io.trino.plugin.redshift.RedshiftSessionProperties;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class RedshiftUnloadJdbcQueryEventListener
implements JdbcQueryEventListener {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final String unloadLocation;

    @Inject
    public RedshiftUnloadJdbcQueryEventListener(@FileSystemS3 TrinoFileSystemFactory fileSystemFactory, RedshiftConfig redshiftConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.unloadLocation = redshiftConfig.getUnloadLocation().orElseThrow();
    }

    public void beginQuery(ConnectorSession session) {
    }

    public void cleanupQuery(ConnectorSession session) {
        if (RedshiftSessionProperties.isUnloadEnabled(session)) {
            try {
                this.fileSystemFactory.create(session).deleteDirectory(Location.of((String)(this.unloadLocation + "/" + session.getQueryId())));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

