/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.trino.spi.block.Block;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import java.util.function.BiFunction;

final class TimestampHolder {
    private final long seconds;
    private final int nanosOfSecond;

    private TimestampHolder(long epochMicros, int picosOfMicro) {
        this.seconds = Math.floorDiv(epochMicros, 1000000);
        long picosOfSecond = (long)Math.floorMod(epochMicros, 1000000) * 1000000L + (long)picosOfMicro;
        this.nanosOfSecond = Math.toIntExact(picosOfSecond / 1000L);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanosOfSecond() {
        return this.nanosOfSecond;
    }

    public static BiFunction<Block, Integer, TimestampHolder> getFactory(TimestampType type) {
        if (type.isShort()) {
            return (block, position) -> new TimestampHolder(type.getLong(block, position.intValue()), 0);
        }
        return (block, position) -> {
            LongTimestamp longTimestamp = (LongTimestamp)type.getObject(block, position.intValue());
            return new TimestampHolder(longTimestamp.getEpochMicros(), longTimestamp.getPicosOfMicro());
        };
    }
}

