/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.HiveFormatUtils;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;

public class DateEncoding
implements TextColumnEncoding {
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public DateEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        this.encodeValue(block, position, output);
    }

    private void encodeValue(Block block, int position, SliceOutput output) {
        this.buffer.setLength(0);
        HiveFormatUtils.formatHiveDate(block, position, this.buffer);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.decodeValue(builder, slice, offset, length);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.decodeValue(builder, slice, offset, length);
    }

    private void decodeValue(BlockBuilder builder, Slice slice, int offset, int length) {
        try {
            LocalDate localDate = HiveFormatUtils.parseHiveDate(slice.toStringAscii(offset, length));
            this.type.writeLong(builder, localDate.toEpochDay());
        }
        catch (DateTimeParseException e) {
            builder.appendNull();
        }
    }
}

