/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.SharedAccessPolicy;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import java.util.EnumSet;

public final class SharedAccessBlobPolicy
extends SharedAccessPolicy {
    private EnumSet<SharedAccessBlobPermissions> permissions;

    public EnumSet<SharedAccessBlobPermissions> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(EnumSet<SharedAccessBlobPermissions> permissions) {
        this.permissions = permissions;
    }

    @Override
    public String permissionsToString() {
        if (this.permissions == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.permissions.contains((Object)SharedAccessBlobPermissions.READ)) {
            builder.append("r");
        }
        if (this.permissions.contains((Object)SharedAccessBlobPermissions.ADD)) {
            builder.append("a");
        }
        if (this.permissions.contains((Object)SharedAccessBlobPermissions.CREATE)) {
            builder.append("c");
        }
        if (this.permissions.contains((Object)SharedAccessBlobPermissions.WRITE)) {
            builder.append("w");
        }
        if (this.permissions.contains((Object)SharedAccessBlobPermissions.DELETE)) {
            builder.append("d");
        }
        if (this.permissions.contains((Object)SharedAccessBlobPermissions.LIST)) {
            builder.append("l");
        }
        return builder.toString();
    }

    @Override
    public void setPermissionsFromString(String value) {
        EnumSet<SharedAccessBlobPermissions> initial = EnumSet.noneOf(SharedAccessBlobPermissions.class);
        block8: for (char c : value.toCharArray()) {
            switch (c) {
                case 'r': {
                    initial.add(SharedAccessBlobPermissions.READ);
                    continue block8;
                }
                case 'a': {
                    initial.add(SharedAccessBlobPermissions.ADD);
                    continue block8;
                }
                case 'c': {
                    initial.add(SharedAccessBlobPermissions.CREATE);
                    continue block8;
                }
                case 'w': {
                    initial.add(SharedAccessBlobPermissions.WRITE);
                    continue block8;
                }
                case 'd': {
                    initial.add(SharedAccessBlobPermissions.DELETE);
                    continue block8;
                }
                case 'l': {
                    initial.add(SharedAccessBlobPermissions.LIST);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("value");
                }
            }
        }
        this.permissions = initial;
    }
}

