/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.security;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.security.RemoteWasbDelegationTokenManager;
import org.apache.hadoop.fs.azure.security.WasbDelegationTokenIdentifier;
import org.apache.hadoop.fs.azure.security.WasbDelegationTokenManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;

public class WasbTokenRenewer
extends TokenRenewer {
    public static final Logger LOG = LoggerFactory.getLogger(WasbTokenRenewer.class);

    @Override
    public boolean handleKind(Text kind) {
        return WasbDelegationTokenIdentifier.TOKEN_KIND.equals(kind);
    }

    @Override
    public boolean isManaged(Token<?> token) throws IOException {
        return true;
    }

    @Override
    public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Renewing the delegation token");
        return this.getInstance(conf).renewDelegationToken(token);
    }

    @Override
    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Cancelling the delegation token");
        this.getInstance(conf).cancelDelegationToken(token);
    }

    private WasbDelegationTokenManager getInstance(Configuration conf) throws IOException {
        return new RemoteWasbDelegationTokenManager(conf);
    }
}

