/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ComparisonOperator;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.BooleanType;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RewriteComparison
implements ConnectorExpressionRule<Call, ParameterizedExpression> {
    private static final Capture<ConnectorExpression> LEFT = Capture.newCapture();
    private static final Capture<ConnectorExpression> RIGHT = Capture.newCapture();
    private final Pattern<Call> pattern;

    public RewriteComparison(Set<ComparisonOperator> enabledOperators) {
        Set functionNames = (Set)enabledOperators.stream().map(ComparisonOperator::getFunctionName).collect(ImmutableSet.toImmutableSet());
        this.pattern = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().matching(functionNames::contains)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.expression().capturedAs(LEFT))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.expression().capturedAs(RIGHT)));
    }

    public Pattern<Call> getPattern() {
        return this.pattern;
    }

    public Optional<ParameterizedExpression> rewrite(Call call, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Optional left = context.defaultRewrite((ConnectorExpression)captures.get(LEFT));
        if (left.isEmpty()) {
            return Optional.empty();
        }
        Optional right = context.defaultRewrite((ConnectorExpression)captures.get(RIGHT));
        if (right.isEmpty()) {
            return Optional.empty();
        }
        Verify.verify((boolean)call.getFunctionName().getCatalogSchema().isEmpty());
        ComparisonOperator operator = ComparisonOperator.forFunctionName(call.getFunctionName());
        return Optional.of(new ParameterizedExpression(String.format("(%s) %s (%s)", ((ParameterizedExpression)left.get()).expression(), operator.getOperator(), ((ParameterizedExpression)right.get()).expression()), (List<QueryParameter>)ImmutableList.builder().addAll(((ParameterizedExpression)left.get()).parameters()).addAll(((ParameterizedExpression)right.get()).parameters()).build()));
    }
}

