/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypePattern;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class TypeClassPattern
implements TypePattern {
    private final String typeClassName;
    private final Set<String> typeNames;
    private final Pattern<Type> pattern;

    public TypeClassPattern(String typeClassName, Set<String> typeNames) {
        this.typeClassName = Objects.requireNonNull(typeClassName, "typeClassName is null");
        this.typeNames = ImmutableSet.copyOf((Collection)Objects.requireNonNull(typeNames, "typeNames is null"));
        this.pattern = Pattern.typeOf(Type.class).with(TypeClassPattern.baseName().matching(this.typeNames::contains));
    }

    @Override
    public Pattern<Type> getPattern() {
        return this.pattern;
    }

    @Override
    public void resolve(Captures captures, MatchContext matchContext) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeClassPattern that = (TypeClassPattern)o;
        return Objects.equals(this.typeClassName, that.typeClassName) && Objects.equals(this.typeNames, that.typeNames);
    }

    public int hashCode() {
        return Objects.hash(this.typeClassName, this.typeNames);
    }

    public String toString() {
        return this.typeClassName;
    }

    private static Property<Type, ?, String> baseName() {
        return Property.property((String)"baseName", Type::getBaseName);
    }
}

