/*
 * Decompiled with CFR 0.152.
 */
package alluxio.refresh;

import alluxio.refresh.RefreshPolicy;
import alluxio.util.CommonUtils;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TimeoutRefresh
implements RefreshPolicy {
    private final long mRefreshPeriodMs;
    private long mLastAttempTimeMs = 0L;
    private boolean mFirstAttempt = true;

    public TimeoutRefresh(long refreshPeriodMs) {
        Preconditions.checkArgument((refreshPeriodMs > 0L ? 1 : 0) != 0, (Object)"Retry timeout must be a positive number");
        this.mRefreshPeriodMs = refreshPeriodMs;
    }

    @Override
    public boolean attempt() {
        if (this.mFirstAttempt || CommonUtils.getCurrentMs() - this.mLastAttempTimeMs > this.mRefreshPeriodMs) {
            this.mLastAttempTimeMs = CommonUtils.getCurrentMs();
            this.mFirstAttempt = false;
            return true;
        }
        return false;
    }
}

