/*
 * Decompiled with CFR 0.152.
 */
package alluxio.time;

import alluxio.time.Sleeper;
import alluxio.time.ThreadSleeper;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Supplier;

public final class SteppingThreadSleeper
implements Sleeper {
    private long mSleepStepMs = 60000L;
    public static final SteppingThreadSleeper INSTANCE = new SteppingThreadSleeper();
    private final Sleeper mInternalSleeper;
    private final Clock mClock;

    private SteppingThreadSleeper() {
        this.mInternalSleeper = ThreadSleeper.INSTANCE;
        this.mClock = Clock.systemUTC();
    }

    @VisibleForTesting
    public SteppingThreadSleeper(Sleeper internalSleeper, Clock clock) {
        this.mInternalSleeper = internalSleeper;
        this.mClock = clock;
    }

    @Override
    public void sleep(Duration duration) throws InterruptedException {
        this.mInternalSleeper.sleep(duration);
    }

    @Override
    public void sleep(Supplier<Duration> durationSupplier) throws InterruptedException {
        long timeNow;
        Duration duration = durationSupplier.get();
        if (duration.toMillis() < 0L) {
            return;
        }
        if (duration.toMillis() < this.mSleepStepMs) {
            this.sleep(duration);
            return;
        }
        long startSleepMs = this.mClock.millis();
        long sleepTo = startSleepMs + duration.toMillis();
        while ((timeNow = this.mClock.millis()) < sleepTo) {
            long sleepTime = Math.min(sleepTo - timeNow, this.mSleepStepMs);
            this.mInternalSleeper.sleep(Duration.ofMillis(sleepTime));
            long newInterval = durationSupplier.get().toMillis();
            if (newInterval < 0L) continue;
            sleepTo = startSleepMs + newInterval;
        }
    }

    @VisibleForTesting
    public void setSleepStepMs(long sleepStepMs) {
        this.mSleepStepMs = sleepStepMs;
    }
}

