/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Inject;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.HiveBucketFunction;
import io.trino.plugin.hive.HivePartitionedBucketFunction;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveUpdateBucketFunction;
import io.trino.plugin.hive.HiveUpdateHandle;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;

    @Inject
    public HiveNodePartitioningProvider(TypeManager typeManager) {
        this.typeOperators = typeManager.getTypeOperators();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        if (partitioningHandle instanceof HiveUpdateHandle) {
            return new HiveUpdateBucketFunction(bucketCount);
        }
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveBucketTypes = handle.getHiveTypes();
        if (!handle.isUsePartitionedBucketing()) {
            return new HiveBucketFunction(handle.getBucketingVersion(), bucketCount, hiveBucketTypes);
        }
        return new HivePartitionedBucketFunction(handle.getBucketingVersion(), handle.getBucketCount(), hiveBucketTypes, partitionChannelTypes.subList(hiveBucketTypes.size(), partitionChannelTypes.size()), this.typeOperators, bucketCount);
    }

    public Optional<ConnectorBucketNodeMap> getBucketNodeMapping(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        if (!handle.isUsePartitionedBucketing()) {
            return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((int)handle.getBucketCount()).withCacheKeyHint(handle.getCacheKeyHint()));
        }
        return Optional.empty();
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, int bucketCount) {
        return value -> ((HiveSplit)value).getReadBucketNumber().orElseThrow(() -> new IllegalArgumentException("Bucket number not set in split"));
    }
}

