/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hive.formats.avro.AvroFileReader;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.avro.Schema;

public class AvroPageSource
implements ConnectorPageSource {
    private static final long GUESSED_MEMORY_USAGE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private final String fileName;
    private final AvroFileReader avroFileReader;

    public AvroPageSource(TrinoInputFile inputFile, Schema schema, AvroTypeBlockHandler avroTypeManager, long offset, long length) throws IOException, AvroTypeException {
        this.fileName = Objects.requireNonNull(inputFile, "inputFile is null").location().fileName();
        this.avroFileReader = new AvroFileReader(inputFile, schema, avroTypeManager, offset, OptionalLong.of(length));
    }

    public long getCompletedBytes() {
        return this.avroFileReader.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.avroFileReader.getReadTimeNanos();
    }

    public boolean isFinished() {
        try {
            return !this.avroFileReader.hasNext();
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to read Avro file: " + this.fileName, (Throwable)e);
        }
    }

    public Page getNextPage() {
        try {
            if (this.avroFileReader.hasNext()) {
                return this.avroFileReader.next();
            }
            return null;
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to read Avro file: " + this.fileName, (Throwable)e);
        }
    }

    public long getMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    public void close() throws IOException {
        this.avroFileReader.close();
    }
}

