/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.plugin.hive.fs.RemoteIterator;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;

public class TrinoFileStatusRemoteIterator
implements RemoteIterator<TrinoFileStatus> {
    private final FileIterator iterator;
    private final Predicate<FileEntry> filterPredicate;
    @Nullable
    private TrinoFileStatus nextElement;

    public TrinoFileStatusRemoteIterator(FileIterator iterator, Predicate<FileEntry> filterPredicate) throws IOException {
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        this.filterPredicate = Objects.requireNonNull(filterPredicate, "filterPredicate is null");
        this.nextElement = this.findNextElement();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.nextElement != null;
    }

    @Override
    public TrinoFileStatus next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        TrinoFileStatus thisElement = this.nextElement;
        this.nextElement = this.findNextElement();
        return thisElement;
    }

    private TrinoFileStatus findNextElement() throws IOException {
        while (this.iterator.hasNext()) {
            FileEntry candidate = this.iterator.next();
            if (!this.filterPredicate.test(candidate)) continue;
            return new TrinoFileStatus(candidate);
        }
        return null;
    }
}

