/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.base.ssl.SslUtils;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.MetastoreSupportsDateStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.Transport;
import io.trino.spi.NodeManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class DefaultThriftMetastoreClientFactory
implements ThriftMetastoreClientFactory {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostAndPort> socksProxy;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final HiveMetastoreAuthentication metastoreAuthentication;
    private final String hostname;
    private final Optional<String> catalogName;
    private final MetastoreSupportsDateStatistics metastoreSupportsDateStatistics = new MetastoreSupportsDateStatistics();
    private final AtomicInteger chosenGetTableAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenTableParamAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenAlterTransactionalTableAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenAlterPartitionsAlternative = new AtomicInteger(Integer.MAX_VALUE);

    public DefaultThriftMetastoreClientFactory(Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, Duration connectTimeout, Duration readTimeout, HiveMetastoreAuthentication metastoreAuthentication, String hostname, Optional<String> catalogName) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext is null");
        this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
        this.connectTimeoutMillis = Math.toIntExact(connectTimeout.toMillis());
        this.readTimeoutMillis = Math.toIntExact(readTimeout.toMillis());
        this.metastoreAuthentication = Objects.requireNonNull(metastoreAuthentication, "metastoreAuthentication is null");
        this.hostname = Objects.requireNonNull(hostname, "hostname is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    @Inject
    public DefaultThriftMetastoreClientFactory(ThriftMetastoreConfig config, HiveMetastoreAuthentication metastoreAuthentication, NodeManager nodeManager) {
        this(DefaultThriftMetastoreClientFactory.buildSslContext(config.isTlsEnabled(), Optional.ofNullable(config.getKeystorePath()), Optional.ofNullable(config.getKeystorePassword()), Optional.ofNullable(config.getTruststorePath()), Optional.ofNullable(config.getTruststorePassword())), Optional.ofNullable(config.getSocksProxy()), config.getConnectTimeout(), config.getReadTimeout(), metastoreAuthentication, nodeManager.getCurrentNode().getHost(), config.getCatalogName());
    }

    @Override
    public ThriftMetastoreClient create(URI uri, Optional<String> delegationToken) throws TTransportException {
        return this.create(() -> this.getTransportSupplier(uri, delegationToken), this.hostname);
    }

    private TTransport getTransportSupplier(URI uri, Optional<String> delegationToken) throws TTransportException {
        Preconditions.checkArgument((boolean)uri.getScheme().toLowerCase(Locale.ENGLISH).equals("thrift"), (String)"Invalid metastore uri scheme %s", (Object)uri.getScheme());
        return this.createTransport(HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort()), delegationToken);
    }

    protected ThriftMetastoreClient create(ThriftHiveMetastoreClient.TransportSupplier transportSupplier, String hostname) throws TTransportException {
        return new ThriftHiveMetastoreClient(transportSupplier, hostname, this.catalogName, this.metastoreSupportsDateStatistics, true, this.chosenGetTableAlternative, this.chosenTableParamAlternative, this.chosenAlterTransactionalTableAlternative, this.chosenAlterPartitionsAlternative);
    }

    private TTransport createTransport(HostAndPort address, Optional<String> delegationToken) throws TTransportException {
        return Transport.create(address, this.sslContext, this.socksProxy, this.connectTimeoutMillis, this.readTimeoutMillis, this.metastoreAuthentication, delegationToken);
    }

    private static Optional<SSLContext> buildSslContext(boolean tlsEnabled, Optional<File> keyStorePath, Optional<String> keyStorePassword, Optional<File> trustStorePath, Optional<String> trustStorePassword) {
        if (!tlsEnabled) {
            return Optional.empty();
        }
        try {
            return Optional.of(SslUtils.createSSLContext(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

