/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.plugin.base.security.UserNameProvider;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.thrift.ForHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;

public class TokenFetchingMetastoreClientFactory
implements IdentityAwareMetastoreClientFactory {
    private final TokenAwareMetastoreClientFactory clientProvider;
    private final UserNameProvider userNameProvider;
    private final boolean impersonationEnabled;
    private final NonEvictableLoadingCache<String, DelegationToken> delegationTokenCache;
    private final long refreshPeriod;
    private final ThriftMetastoreStats stats = new ThriftMetastoreStats();
    private final RetryPolicy retryPolicy;

    @Inject
    public TokenFetchingMetastoreClientFactory(TokenAwareMetastoreClientFactory tokenAwareMetastoreClientFactory, @ForHiveMetastore UserNameProvider userNameProvider, ThriftMetastoreConfig thriftConfig) {
        this.clientProvider = Objects.requireNonNull(tokenAwareMetastoreClientFactory, "tokenAwareMetastoreClientFactory is null");
        this.impersonationEnabled = thriftConfig.isImpersonationEnabled();
        this.userNameProvider = Objects.requireNonNull(userNameProvider, "userNameProvider is null");
        this.delegationTokenCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(thriftConfig.getDelegationTokenCacheTtl().toMillis(), TimeUnit.MILLISECONDS).maximumSize(thriftConfig.getDelegationTokenCacheMaximumSize()), (CacheLoader)CacheLoader.from(this::loadDelegationToken));
        this.refreshPeriod = Duration.ofMinutes(1L).toNanos();
        this.retryPolicy = RetryPolicy.builder().withMaxDuration(thriftConfig.getMaxRetryTime().toJavaTime()).withMaxAttempts(thriftConfig.getMaxRetries() + 1).withBackoff(thriftConfig.getMinBackoffDelay().toMillis(), thriftConfig.getMaxBackoffDelay().toMillis(), ChronoUnit.MILLIS, thriftConfig.getBackoffScaleFactor()).abortOn(TException.class).build();
    }

    private ThriftMetastoreClient createMetastoreClient() throws TException {
        return this.clientProvider.createMetastoreClient(Optional.empty());
    }

    @Override
    public ThriftMetastoreClient createMetastoreClientFor(Optional<ConnectorIdentity> identity) throws TException {
        if (!this.impersonationEnabled) {
            return this.createMetastoreClient();
        }
        String username = identity.map(arg_0 -> ((UserNameProvider)this.userNameProvider).get(arg_0)).orElseThrow(() -> new IllegalStateException("End-user name should exist when metastore impersonation is enabled"));
        DelegationToken cachedDelegationToken = this.getDelegationToken(username);
        try {
            return this.clientProvider.createMetastoreClient(Optional.of(cachedDelegationToken.delegationToken()));
        }
        catch (TException e) {
            if (System.nanoTime() - cachedDelegationToken.writeTimeNanos() >= this.refreshPeriod) {
                DelegationToken refreshDelegationToken = this.loadDelegationToken(username);
                this.delegationTokenCache.put((Object)username, (Object)refreshDelegationToken);
                return this.clientProvider.createMetastoreClient(Optional.of(refreshDelegationToken.delegationToken()));
            }
            throw e;
        }
    }

    private DelegationToken getDelegationToken(String username) {
        try {
            return (DelegationToken)this.delegationTokenCache.getUnchecked((Object)username);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
    }

    private DelegationToken loadDelegationToken(String username) {
        try {
            return (DelegationToken)Failsafe.with((Policy)this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.stats.getThriftDelegationToken().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    DelegationToken delegationToken = new DelegationToken(System.nanoTime(), client.getDelegationToken(username));
                    return delegationToken;
                }
            }).call());
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof TException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e.getCause());
            }
            throw e;
        }
    }

    private record DelegationToken(long writeTimeNanos, String delegationToken) {
        public DelegationToken {
            Objects.requireNonNull(delegationToken, "delegationToken is null");
        }
    }
}

