/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.plugin.hive.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class InjectedProjection
implements Projection {
    private final String columnName;

    public InjectedProjection(String columnName, Type columnType) {
        if (!MetastoreUtil.canConvertSqlTypeToStringForParts(columnType, true)) {
            throw new InvalidProjectionException(columnName, columnType);
        }
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        Domain domain = partitionValueFilter.orElseThrow(() -> new InvalidProjectionException(this.columnName, "Injected projection requires single predicate for it's column in where clause"));
        Type type = domain.getType();
        if (!domain.isNullableSingleValue() || !MetastoreUtil.canConvertSqlTypeToStringForParts(type, true)) {
            throw new InvalidProjectionException(this.columnName, "Injected projection requires single predicate for it's column in where clause. Currently provided can't be converted to single partition.");
        }
        return (List)Optional.ofNullable(MetastoreUtil.sqlScalarToString(type, domain.getNullableSingleValue(), null)).map(ImmutableList::of).orElseThrow(() -> new InvalidProjectionException(this.columnName, type));
    }
}

