/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metastore.HivePartition;
import io.trino.metastore.PartitionStatistics;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.statistics.AbstractHiveStatisticsProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetastoreHiveStatisticsProvider
extends AbstractHiveStatisticsProvider {
    private final SemiTransactionalHiveMetastore metastore;

    public MetastoreHiveStatisticsProvider(SemiTransactionalHiveMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    protected Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SchemaTableName table, List<HivePartition> hivePartitions, Set<String> columns) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return ImmutableMap.of();
        }
        if (hivePartitions.isEmpty()) {
            return ImmutableMap.of();
        }
        boolean unpartitioned = hivePartitions.stream().anyMatch(partition -> partition.getPartitionId().equals("<UNPARTITIONED>"));
        if (unpartitioned) {
            Preconditions.checkArgument((hivePartitions.size() == 1 ? 1 : 0) != 0, (Object)"expected only one hive partition");
            return ImmutableMap.of((Object)"<UNPARTITIONED>", (Object)this.metastore.getTableStatistics(table.getSchemaName(), table.getTableName(), Optional.of(columns)));
        }
        Set partitionNames = (Set)hivePartitions.stream().map(HivePartition::getPartitionId).collect(ImmutableSet.toImmutableSet());
        return this.metastore.getPartitionStatistics(table.getSchemaName(), table.getTableName(), columns, partitionNames);
    }
}

