/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.ListTypeInfo;
import io.trino.metastore.type.MapTypeInfo;
import io.trino.metastore.type.StructTypeInfo;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

public final class HiveCoercionPolicy {
    private final TypeManager typeManager;

    private HiveCoercionPolicy(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public static boolean canCoerce(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        return new HiveCoercionPolicy(typeManager).canCoerce(fromHiveType, toHiveType, hiveTimestampPrecision);
    }

    private boolean canCoerce(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        Type fromType = this.typeManager.getType(HiveTypeUtil.getTypeSignature(fromHiveType, hiveTimestampPrecision));
        Type toType = this.typeManager.getType(HiveTypeUtil.getTypeSignature(toHiveType, hiveTimestampPrecision));
        if (fromType instanceof VarcharType) {
            return toType instanceof VarcharType || toType instanceof CharType || toHiveType.equals((Object)HiveType.HIVE_BOOLEAN) || toHiveType.equals((Object)HiveType.HIVE_BYTE) || toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG) || toHiveType.equals((Object)HiveType.HIVE_FLOAT) || toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toHiveType.equals((Object)HiveType.HIVE_DATE) || toHiveType.equals((Object)HiveType.HIVE_TIMESTAMP);
        }
        if (fromType instanceof CharType) {
            return toType instanceof CharType || toType instanceof VarcharType;
        }
        if (toType instanceof VarcharType) {
            return fromHiveType.equals((Object)HiveType.HIVE_BOOLEAN) || fromHiveType.equals((Object)HiveType.HIVE_BYTE) || fromHiveType.equals((Object)HiveType.HIVE_SHORT) || fromHiveType.equals((Object)HiveType.HIVE_INT) || fromHiveType.equals((Object)HiveType.HIVE_LONG) || fromHiveType.equals((Object)HiveType.HIVE_TIMESTAMP) || fromHiveType.equals((Object)HiveType.HIVE_FLOAT) || fromHiveType.equals((Object)HiveType.HIVE_DOUBLE) || fromHiveType.equals((Object)HiveType.HIVE_DATE) || fromType instanceof DecimalType || fromType instanceof VarbinaryType;
        }
        if (toHiveType.equals((Object)HiveType.HIVE_DATE)) {
            return fromHiveType.equals((Object)HiveType.HIVE_TIMESTAMP);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_BYTE)) {
            return toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG) || toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_SHORT)) {
            return toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG) || toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_INT)) {
            return toHiveType.equals((Object)HiveType.HIVE_LONG) || toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_LONG)) {
            return toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_FLOAT)) {
            return toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_DOUBLE)) {
            return toHiveType.equals((Object)HiveType.HIVE_FLOAT) || toType instanceof DecimalType;
        }
        if (fromType instanceof DecimalType) {
            return toType instanceof DecimalType || toHiveType.equals((Object)HiveType.HIVE_FLOAT) || toHiveType.equals((Object)HiveType.HIVE_DOUBLE) || toHiveType.equals((Object)HiveType.HIVE_BYTE) || toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG);
        }
        return this.canCoerceForList(fromHiveType, toHiveType, hiveTimestampPrecision) || this.canCoerceForMap(fromHiveType, toHiveType, hiveTimestampPrecision) || this.canCoerceForStructOrUnion(fromHiveType, toHiveType, hiveTimestampPrecision);
    }

    private boolean canCoerceForMap(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        if (fromHiveType.getCategory() != Category.MAP || toHiveType.getCategory() != Category.MAP) {
            return false;
        }
        HiveType fromKeyType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType fromValueType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        HiveType toKeyType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType toValueType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        return !(!fromKeyType.equals((Object)toKeyType) && !this.canCoerce(fromKeyType, toKeyType, hiveTimestampPrecision) || !fromValueType.equals((Object)toValueType) && !this.canCoerce(fromValueType, toValueType, hiveTimestampPrecision));
    }

    private boolean canCoerceForList(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        HiveType toElementType;
        if (fromHiveType.getCategory() != Category.LIST || toHiveType.getCategory() != Category.LIST) {
            return false;
        }
        HiveType fromElementType = HiveType.valueOf((String)((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
        return fromElementType.equals((Object)(toElementType = HiveType.valueOf((String)((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName()))) || this.canCoerce(fromElementType, toElementType, hiveTimestampPrecision);
    }

    private boolean canCoerceForStructOrUnion(HiveType fromHiveType, HiveType toHiveType, HiveTimestampPrecision hiveTimestampPrecision) {
        if (!HiveCoercionPolicy.isStructOrUnion(fromHiveType) || !HiveCoercionPolicy.isStructOrUnion(toHiveType)) {
            return false;
        }
        HiveType fromHiveTypeStruct = fromHiveType.getCategory() == Category.UNION ? HiveCoercionPolicy.convertUnionToStruct(fromHiveType, this.typeManager, hiveTimestampPrecision) : fromHiveType;
        HiveType toHiveTypeStruct = toHiveType.getCategory() == Category.UNION ? HiveCoercionPolicy.convertUnionToStruct(toHiveType, this.typeManager, hiveTimestampPrecision) : toHiveType;
        List fromFieldNames = ((StructTypeInfo)fromHiveTypeStruct.getTypeInfo()).getAllStructFieldNames();
        List toFieldNames = ((StructTypeInfo)toHiveTypeStruct.getTypeInfo()).getAllStructFieldNames();
        List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveTypeStruct);
        List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveTypeStruct);
        for (int i = 0; i < Math.min(fromFieldTypes.size(), toFieldTypes.size()); ++i) {
            if (!((String)fromFieldNames.get(i)).equalsIgnoreCase((String)toFieldNames.get(i))) {
                return false;
            }
            if (fromFieldTypes.get(i).equals((Object)toFieldTypes.get(i)) || this.canCoerce(fromFieldTypes.get(i), toFieldTypes.get(i), hiveTimestampPrecision)) continue;
            return false;
        }
        return true;
    }

    private static boolean isStructOrUnion(HiveType hiveType) {
        return hiveType.getCategory() == Category.STRUCT || hiveType.getCategory() == Category.UNION;
    }

    private static HiveType convertUnionToStruct(HiveType unionType, TypeManager typeManager, HiveTimestampPrecision hiveTimestampPrecision) {
        Preconditions.checkArgument((unionType.getCategory() == Category.UNION ? 1 : 0) != 0, (Object)String.format("Can only convert union type to struct type, given type: %s", HiveTypeUtil.getTypeSignature(unionType, hiveTimestampPrecision)));
        return HiveTypeTranslator.toHiveType(HiveTypeUtil.getType(unionType, typeManager, hiveTimestampPrecision));
    }
}

