/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class GlobalSection
extends Section {
    private final List<Global> globals;

    private GlobalSection(List<Global> globals) {
        super(6L);
        this.globals = List.copyOf(globals);
    }

    public Global[] globals() {
        return (Global[])this.globals.toArray(Global[]::new);
    }

    public int globalCount() {
        return this.globals.size();
    }

    public Global getGlobal(int idx) {
        return this.globals.get(idx);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Global> globals = new ArrayList<Global>();

        private Builder() {
        }

        public Builder addGlobal(Global global) {
            Objects.requireNonNull(global, "global");
            this.globals.add(global);
            return this;
        }

        public GlobalSection build() {
            return new GlobalSection(this.globals);
        }
    }
}

