/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TypeSection
extends Section {
    private final List<FunctionType> types;

    private TypeSection(List<FunctionType> types) {
        super(1L);
        this.types = List.copyOf(types);
    }

    public FunctionType[] types() {
        return (FunctionType[])this.types.toArray(FunctionType[]::new);
    }

    public int typeCount() {
        return this.types.size();
    }

    public FunctionType getType(int idx) {
        return this.types.get(idx);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<FunctionType> types = new ArrayList<FunctionType>();

        private Builder() {
        }

        public Builder addFunctionType(FunctionType functionType) {
            Objects.requireNonNull(functionType, "functionType");
            this.types.add(functionType);
            return this;
        }

        public TypeSection build() {
            return new TypeSection(this.types);
        }
    }
}

