/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import io.trino.hive.formats.avro.AvroTypeBlockHandler;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.hive.formats.avro.RowBlockBuildingDecoder;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;

public class AvroPageDataReader
implements DatumReader<Optional<Page>> {
    private final Schema readerSchema;
    private Schema writerSchema;
    private final PageBuilder pageBuilder;
    private RowBlockBuildingDecoder rowBlockBuildingDecoder;
    private final AvroTypeBlockHandler typeManager;

    public AvroPageDataReader(Schema readerSchema, AvroTypeBlockHandler typeManager) throws AvroTypeException {
        this.writerSchema = this.readerSchema = Objects.requireNonNull(readerSchema, "readerSchema is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        AvroTypeUtils.verifyNoCircularReferences(readerSchema);
        try {
            Type readerSchemaType = typeManager.typeFor(readerSchema);
            Verify.verify((boolean)(readerSchemaType instanceof RowType), (String)"Root Avro type must be a row", (Object[])new Object[0]);
            this.pageBuilder = new PageBuilder(readerSchemaType.getTypeParameters());
            this.initialize();
        }
        catch (org.apache.avro.AvroTypeException e) {
            throw new AvroTypeException(e);
        }
    }

    private void initialize() throws AvroTypeException {
        Verify.verify((this.readerSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"Avro schema for page reader must be record", (Object[])new Object[0]);
        Verify.verify((this.writerSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"File Avro schema for page reader must be record", (Object[])new Object[0]);
        this.rowBlockBuildingDecoder = new RowBlockBuildingDecoder(this.writerSchema, this.readerSchema, this.typeManager);
    }

    public void setSchema(Schema schema) {
        Objects.requireNonNull(schema, "schema is null");
        if (schema != this.writerSchema) {
            this.writerSchema = schema;
            try {
                this.initialize();
            }
            catch (org.apache.avro.AvroTypeException e) {
                throw new UncheckedAvroTypeException(new AvroTypeException(e));
            }
            catch (AvroTypeException e) {
                throw new UncheckedAvroTypeException(e);
            }
        }
    }

    public Optional<Page> read(Optional<Page> ignoredReuse, Decoder decoder) throws IOException {
        Optional<Page> page = Optional.empty();
        this.rowBlockBuildingDecoder.decodeIntoPageBuilder(decoder, this.pageBuilder);
        if (this.pageBuilder.isFull()) {
            page = Optional.of(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return page;
    }

    public Optional<Page> flush() {
        if (!this.pageBuilder.isEmpty()) {
            Optional<Page> lastPage = Optional.of(this.pageBuilder.build());
            this.pageBuilder.reset();
            return lastPage;
        }
        return Optional.empty();
    }

    protected static class UncheckedAvroTypeException
    extends RuntimeException {
        private final AvroTypeException avroTypeException;

        public UncheckedAvroTypeException(AvroTypeException cause) {
            super(Objects.requireNonNull(cause, "cause is null"));
            this.avroTypeException = cause;
        }

        public AvroTypeException getAvroTypeException() {
            return this.avroTypeException;
        }
    }
}

